//
//  OrderCasePoolListVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/5.
//

import UIKit

class OrderCasePoolListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var viewType = 0   //0、标准案例；1、案例工单
    
    var models: [M_OrderCasePool] = []
    
    var callBack:((String)->Void)?
}

extension OrderCasePoolListVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        for (i,item) in models.enumerated() {
            newForms += makeLineCellForm(type: .clear, idx: -99)
            let titleStr = viewType == 0 ? "\("标准案例编码".languageString())  \(item.caseDemoNo)" : "\("工单号".languageString())  \(item.orderNo)"
            newForms += makeTitleCellForm(titleStr:titleStr , statusStr: "", corner: (8, [.topLeft, .topRight]), idx: i)
            newForms += makeLineCellForm(type: .line, height: 1, idx: i)
            newForms += makeLineCellForm(type: .white, height: 12, idx: i)
            newForms += makeInfoCellForm(titleStr: "故障描述".languageString(), detailStr: item.fault, idx: i)
            newForms += makeLineCellForm(type: .white, height: 12, idx: i)
            newForms += makeInfoCellForm(titleStr: "产品分类".languageString(), detailStr: item.category, idx: i)
            newForms += makeLineCellForm(type: .white, height: 12, idx: i)
            newForms += makeInfoCellForm(titleStr: "发布时间".languageString(), detailStr: item.createTime, idx: i)
            newForms += makeLineCellForm(type: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 12, idx: i)
        }
        newForms += makeLineCellForm(type: .clear, height: 16, idx: -99)
        
        forms = newForms
        reloadData?()
    }
    
    enum LineCellType {
        case line
        case clear
        case white
    }
    func makeLineCellForm(type:LineCellType, corners:(CGFloat, CACornerMask)? = nil, hideLine:Bool? = nil, hideView:Bool? = nil, height:CGFloat? = nil, idx:Int) -> [TCCellBaseProtocol] {
        var corner:(CGFloat, CACornerMask) = (0,[])
        var isLineHidden = true
        var isViewHidden = false
        var hh:CGFloat = 12
        switch type {
        case .line:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? false
            isViewHidden = hideView ?? false
            hh = height ?? 13
        case .clear:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? true
            hh = height ?? 8
        case .white:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? false
            hh = height ?? 8
        }
        let rowCell = TCFormCellModel<WorkbenchTitleCell>.init(data: "", config: (corner, isLineHidden, isViewHidden), frameh: hh, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func makeTitleCellForm(titleStr:String = "", statusStr:String = "", corner:(CGFloat, UIRectCorner) = (0,[]), hh:CGFloat? = nil, idx:Int) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: (titleStr, statusStr), config: corner, frameh: hh ?? UITableView.automaticDimension, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func makeInfoCellForm(titleStr:String, detailStr:String, hh:CGFloat? = nil, idx:Int) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailInfoCell>.init(data: (titleStr, detailStr), frameh: hh ?? UITableView.automaticDimension, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func didSelect(_ idx:Int) {
        guard idx >= 0 else {
            return
        }
        R_OrderCasePoolDetail.router(models[idx].caseDemoId, callback: nil)
    }
}
