//
//  OrderComplainProcessVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/12.
//

import Foundation

class OrderComplainProcessVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var orderId = ""
    
    var models:[M_Process] = []
    var siteComplainStat = 0
    
    var callBack:((Int)->Void)?
}

extension OrderComplainProcessVm {
    func makeForms() {
        guard !models.isEmpty else {
            forms = []
            reloadData?()
            return
        }
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "流程列表".languageString(), corner: (8, [.topLeft, .topRight]))
        do{
            let rowCell = TCFormCellModel<WorkbenchTitleCell>.init(data: "", config: ((0,[]), false, false), frameh: 1)
            newForms.append(rowCell)
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 16)
        for (i,item) in models.enumerated(){
            do{
                let rowCell = TCFormCellModel<OrderComplainProcessCell>.init(data: item, config: i,frameh: UITableView.automaticDimension) { [weak self] tag in
                    guard let weakSelf = self else { return }
                    guard let tag = tag as? Int else { return }
                    weakSelf.showImages(item.imgArr, idx: tag)
                }
                newForms.append(rowCell)
            }
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 16)
        
        forms = newForms
        reloadData?()
    }
    
    func makeTitleCellForm(titleStr:String, statusStr:String = "", corner:(CGFloat, UIRectCorner) = (0,[]), isShowArrow:Bool = false, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: (titleStr, statusStr), config: (corner, isShowArrow), frameh: hh ?? UITableView.automaticDimension)
        return [rowCell]
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
    
    func showImages(_ arr:[String] = [], idx:Int = 0) {
        let imgArr:[(String,UIImage?)] = arr.compactMap { ($0, nil) }
        var photos:[GKPhoto] = []
        for item in imgArr {
            let  photo = GKPhoto()
            if !item.0.isEmpty {
                photo.url = URL(string: item.0)!
            }
            if item.1 != nil {
                photo.image = item.1
            }
            photos.append(photo)
        }
        let browser = GKPhotoBrowser(photos: photos, currentIndex: idx)
        browser.showStyle = .none
        browser.modalPresentationStyle = .overFullScreen
        browser.show(fromVC: CD.visibleVC!)
    }
}
extension OrderComplainProcessVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/getComplainProcess",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                weakSelf.models = data.arrayValue(forKey: "processList").compactMap({M_Process($0)})
                weakSelf.siteComplainStat = data.intValue(forKey: "siteComplainStat")
                weakSelf.callBack?(weakSelf.siteComplainStat)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}

class M_Process: NSObject {
    var id = ""           //过程ID
    var createTime = ""           //时间
    var executorName = ""          //执行人
    var poster = ""           //岗位
    var content = ""           //内容
    var fileUrl1 = ""           //图片1
    var fileUrl2 = ""           //图片2
    var fileUrl3 = ""           //图片3
    var imgArr:[String] = []
    
    init(_ data:[String:Any] = [:]) {
        id = data.stringValue(forKey: "id")
        createTime = data.stringValue(forKey: "createTime")
        executorName = data.stringValue(forKey: "executorName")
        poster = data.stringValue(forKey: "poster")
        content = data.stringValue(forKey: "content")
        fileUrl1 = data.stringValue(forKey: "fileUrl1")
        fileUrl2 = data.stringValue(forKey: "fileUrl2")
        fileUrl3 = data.stringValue(forKey: "fileUrl3")
        
        imgArr = []
        if !fileUrl1.isEmpty {
            imgArr.append(fileUrl1)
        }
        if !fileUrl2.isEmpty {
            imgArr.append(fileUrl2)
        }
        if !fileUrl3.isEmpty {
            imgArr.append(fileUrl3)
        }
    }
}
