//
//  OrderPartsReplaceListVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/15.
//

import Foundation

class OrderPartsReplaceListVm :NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var orderId = ""
    
    var models:[M_OrderPartsInfo.OrderParts] = []
    
    var callBack:((Int)->Void)?
}

extension OrderPartsReplaceListVm {
    func makeForms() {
        guard !models.isEmpty else {
            forms = []
            reloadData?()
            return
        }
        var newForms:[TCCellBaseProtocol] = []
        
        for item in models {
            newForms += makeLineCellForm(height: 8)
            do{
                let rowCell = TCFormCellModel<OrderPartsReplaceListCell>.init(data: item, frameh: UITableView.automaticDimension)
                newForms.append(rowCell)
            }
        }
        newForms += makeLineCellForm(height: 16)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
}
