//
//  OrderSelectPartVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/20.
//

import Foundation

class OrderSelectPartVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var didSelCallback:((M_OrderPartsInfo.Parts)->())?
    var itemArr = [M_OrderPartsInfo.Parts]()
    var applyPartsMode = ""
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []

        newForms += makeItemsForms()
        forms = newForms
        callback?()
    }
    
    func makeItemsForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        
        guard itemArr.count != 0 else {
            return []
        }
        
        for (index,item) in itemArr.enumerated() {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
                newForms.append(rowCell)
            }
            
            // header
            do {
                let name = item.partsName
                let code = item.partsCode
                let pic = item.pic
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartHeader>.init(data: (name,code,pic,item.selected), config: uiConfigModel, id: nil, frameh: 60) { a in
                    //选择
                    self.itemArr[index].selected = !item.selected
                    self.makeForms()
                }
                newForms.append(rowCell)
            }
            
            do {
                let value1 = item.userPrice == "" ? "0.00" : item.userPrice
                let value2 = item.applyQty == "" ? "1" : item.applyQty
                let value3 = item.maxQty == "" ? "1" : item.maxQty
//                let value4 = item.invQty == "" ? "1" : item.invQty
                let value4 = item.myselfQty == "" ? "1" : item.myselfQty
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartNum>.init(data: (value1,value2,"-1",value4), config: uiConfigModel, id: nil, frameh: 40) {[weak self] a in
                    guard let weakSelf = self else { return }
                    if let qty = a as? Int {
                        weakSelf.itemArr[index].applyQty = "\(qty)"
                        weakSelf.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
            
            do {
                let qty2 = item.myselfQty == "" ? "0" : item.myselfQty
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let datas:(String,String) = applyPartsMode == "2" ? ("\("自有库存".languageString())：\(qty2)", "") : ("\("出库仓库库存".languageString())：\(item.invQtyString)","\("自有库存".languageString())：\(qty2)")
                let rowCell = TCFormCellModel<Cell_FinishOrderSelectPartBottom>.init(data: datas, config: uiConfigModel, id: nil, frameh: 44) { a in
                }
                newForms.append(rowCell)
            }
            
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
        }
        
       return newForms
    }
    
}
