//
//  OrderServiceSupportVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/11.
//

import Foundation

class OrderServiceSupportVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var orderId = ""
    
    var model = M_OrderServiceSupport()
    
}

extension OrderServiceSupportVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "知识文档".languageString(), statusStr: "更多".languageString(), corner: (8,[.topLeft, .topRight]), isShowArrow: true)
        for (i,item) in model.knowledgeList.enumerated() {
            newForms += makeKnowledgeCellForm(titleStr: item.title, idStr: item.knowledgeId)
            if i < model.knowledgeList.count - 1 {
                newForms += makeLineCellForm(bgColor: .white,height: 8)
            }else{
                newForms += makeLineCellForm(bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
            }
        }
        
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "技术支持".languageString(), corner: (8,[.topLeft, .topRight]), isShowArrow: false)
        for (i,item) in model.manList.enumerated() {
            newForms += makeSupporterCellForm(headUrl: item.pic, nameStr: item.name, phoneStr: item.mobile, typeStr: item.lable)
            if i < model.manList.count - 1 {
                newForms += makeLineCellForm(bgColor: .white,height: 8)
            }else{
                newForms += makeLineCellForm(bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
            }
        }
        
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "营销建议".languageString(), corner: (8,[.topLeft, .topRight]), isShowArrow: false)
        newForms += makeTextCellForm(str: model.yingXianJianYi)
        newForms += makeLineCellForm(bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
        
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "服务政策".languageString(), corner: (8,[.topLeft, .topRight]), isShowArrow: false)
        newForms += makeTextCellForm(str: model.fuWuJianYi)
        newForms += makeLineCellForm(bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
        newForms += makeLineCellForm(height: 16)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 12, rightW:CGFloat = 12, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
    
    func makeTitleCellForm(titleStr:String, statusStr:String = "", corner:(CGFloat, UIRectCorner) = (0,[]), isShowArrow:Bool = false, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: (titleStr, statusStr), config: (corner, isShowArrow), frameh: hh ?? UITableView.automaticDimension) { [weak self] _ in
            guard let weakSelf = self else { return }
            weakSelf.selectTitle(titleStr)
        }
        return [rowCell]
    }
    
    func makeKnowledgeCellForm(titleStr:String, idStr:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderSupportKnowledgeCell>.init(data: titleStr, frameh:UITableView.automaticDimension, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.selectKnowledge(idStr)
        })
        return [rowCell]
    }
    
    func makeSupporterCellForm(headUrl:String, nameStr:String, phoneStr:String, typeStr:String = "") -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderSupporterCell>.init(data: (headUrl, nameStr, phoneStr, typeStr), frameh:UITableView.automaticDimension) { _ in
            if let callUrl = URL(string :"tel://"+"\(phoneStr)") , UIApplication.shared.canOpenURL(callUrl) {
                if #available(iOS 10.0, *) {
                    UIApplication.shared.open(callUrl)
                }else{
                    UIApplication.shared.openURL(callUrl)
                }
            }else{
                hud_error("电话号码有误！".languageString())
            }
        }
        return [rowCell]
    }
    
    func makeTextCellForm(str:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderSupportTextCell>.init(data: str, frameh:UITableView.automaticDimension)
        return [rowCell]
    }
}

extension OrderServiceSupportVm {
    func selectTitle(_ str:String) {
        switch str {
        case "知识文档".languageString():
            R_ServiceKnowledgeList.router(orderId)
            break
        default:
            break
        }
    }
    
    func selectKnowledge(_ idStr:String) {
        let urlStr = "\(TWOCNetwork.shareNetManager().baseURL)/h5/knowledgeDetail.html?id=\(idStr)&orderId=\(orderId)&userName=\(MyInfo.shareInstance().userName.addingPercentEncoding(withAllowedCharacters: .alphanumerics)!)&token=\(MyInfo.shareInstance().token)"
        R_Web.push(.http(urlStr), title: "知识详情".languageString())
    }
}

extension OrderServiceSupportVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["orderId"] = orderId

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/orderDo/support",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                weakSelf.model = M_OrderServiceSupport(data)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}
