//
//  WorkbenchVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/8/23.
//

import Foundation
import TWOCNetwork

class WorkbenchVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var flushTable = 1   //工作台类型:1服务人员工作台;2企业用户工单台;(必传)
    
    var model = M_Workbench()
    
}

extension WorkbenchVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeTitleCellForm(type: .clear)
        if flushTable == 1 {
            //MARK: --工单台
            do{
                let sendpayArr = model.workerOrderSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_gdlb","工单列表".languageString()),("order_thgl","退换管理".languageString()),("order_jxgl","寄修管理".languageString()),("order_xcjd","现场建单".languageString()),("order_sbzs","设备追溯".languageString()),("order_gdtj","工单统计".languageString()),("order_ypym","一屏一码".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
                    let arrAll2 = [("\(model.unBookQty)","待预约".languageString()),("\(model.unOnDoorQty)","待上门".languageString()),("\(model.unFinishQty)","待完工".languageString()),("\(model.unComfirmEngineerFinishQty)","待确认".languageString()),("\(model.waitPartsQty)","等待备件".languageString()),("\(model.inDeliveryFixQty)","送修中".languageString()),("\(model.inChangeQty)","退换中".languageString()),("\(model.unComplainOrderQty)","待申诉".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "工单台".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "工单台".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "工单台".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear)
                    }
                }
            }
            
            //MARK: --配件台
            do{
                let sendpayArr = model.workerPartsSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_sqlb","申请列表".languageString()),("order_pjBOM","配件BOM".languageString()),("order_hxlb","核销列表".languageString()),("order_pjkc","配件库存".languageString()),("order_pjed","配件额度".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
                    let arrAll2 = [("\(model.waitDeliveryPartsQty)","申请待发货".languageString()),("\(model.unSignPartsQty)","已发货待签收".languageString()),("\(model.unReturnPartsQty)","旧件待核销".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "配件台".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "配件台".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "配件台".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear)
                    }
                }
            }
            
            //MARK: --结算台
            do{
                let sendpayArr = model.workerSettleSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_fqjs","发起结算".languageString()),("order_jsd","结算单".languageString()),("order_khd","考核单".languageString()),("order_tstf","统收统付".languageString()),("order_bjsgd","不结算工单".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
    //                let arrAll2 = [("\(model.unComplainCheckBillQty)","考核申诉"),("\(model.waitCheckSettleQty)","等待审核"),("\(model.unMakeInvoiceQty)","待开发票"),("\(model.unPaymentReceivedQty)","到款确认")]
                    let arrAll2 = [("\(model.unComplainCheckBillQty)","考核申诉".languageString()),("\(model.waitCheckSettleQty)","待确认".languageString()),("\(model.unMakeInvoiceQty)","待开发票".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "结算台".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "结算台".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "结算台".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear, height: 12)
                    }
                }
            }
        }else if flushTable == 2 {
            //MARK: --工程任务
            do{
                let sendpayArr = model.adminTaskSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_gcrw_company","工程任务".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
                    let arrAll2 = [("\(model.todayTastQty)","今日任务".languageString()),("\(model.exeTastQty)","执行中任务".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "工程任务".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "工程任务".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "工程任务".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear)
                    }
                }
            }
            
            //MARK: --工单管理
            do{
                let sendpayArr = model.adminOrderSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_gdlb_company","工单列表".languageString()),("order_thgl_company","退换管理".languageString()),("order_jxgl_company","寄修管理".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
                    let arrAll2 = [("\(model.unTakeSiteQty)","待派工".languageString()),("\(model.unComfirmSiteFinishQty)","完工审核".languageString()),("\(model.unComplainCheckOrderQty)","待申诉审核".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "工单管理".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "工单管理".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "工单管理".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear)
                    }
                }
            }
            
            //MARK: --配件管理
            do{
                let sendpayArr = model.adminPartsSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_sqlb_company","申请列表".languageString()),("order_pjBOM_company","配件BOM".languageString()),("order_hxlb_company","核销列表".languageString()),("order_fwskc_company","服务商库存".languageString()),("order_zbkc_company","总部库存".languageString()),("order_pjed_company","配件额度".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
                    let arrAll2 = [("\(model.unCheckPartsQty)","待审核"),("\(model.unDeliveryPartsQty)","待发货"),("\(model.unReturnPartsCheckQty)","核销待审核")]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "配件管理".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "配件管理".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "配件管理".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear)
                    }
                }
            }
            
            //MARK: --结算管理
            do{
                let sendpayArr = model.adminSettleSendpayArr
                if !sendpayArr.isEmpty {
                    let arrAll1 = [("order_jsd_company","结算单".languageString()),("order_khd_company","考核单".languageString())]
                    let arr1:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll1)
    //                let arrAll2 = [("\(model.unCheckBillQty)","考核待审核"),("\(model.unCheckSettleQty)","结算待审核")]
                    let arrAll2 = [("\(model.unCheckBillQty)","申诉待审核".languageString())]
                    let arr2:[(String, String)] = showArray(sendpayArr: sendpayArr, allArr: arrAll2, arrAll1Count: arrAll1.count)
                    if !arr1.isEmpty || !arr2.isEmpty {
                        newForms += makeTitleCellForm(type: .title, title: "结算管理".languageString())
                        if !arr1.isEmpty {
                            newForms += makeGridCellForms(array: arr1, titleStr: "结算管理".languageString(), type: 1)
                        }
                        if !arr1.isEmpty && !arr2.isEmpty {
                            newForms += makeTitleCellForm(type: .line)
                            newForms += makeTitleCellForm(type: .white, height: 12)
                        }
                        if !arr2.isEmpty {
                            newForms += makeGridCellForms(array: arr2, titleStr: "结算管理".languageString(), type: 2)
                        }
                        newForms += makeTitleCellForm(type: .bottom)
                        newForms += makeTitleCellForm(type: .clear, height: 12)
                    }
                }
            }
        }
        forms = newForms
        reloadData?()
    }
    
    enum WorkbenchTitleCellType {
        case title
        case bottom
        case line
        case clear
        case white
    }
    func makeTitleCellForm(type:WorkbenchTitleCellType, title:String = "", corners:(CGFloat, CACornerMask)? = nil, hideLine:Bool? = nil, hideView:Bool? = nil, height:CGFloat? = nil) -> [TCCellBaseProtocol] {
        var corner:(CGFloat, CACornerMask) = (0,[])
        var isLineHidden = true
        var isViewHidden = false
        var hh:CGFloat = 12
        switch type {
        case .title:
            corner = corners ?? (8, [.layerMinXMinYCorner, .layerMaxXMinYCorner])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? false
            hh = height ?? 50
        case .bottom:
            corner = corners ?? (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? false
            hh = height ?? 12
        case .line:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? false
            isViewHidden = hideView ?? false
            hh = height ?? 13
        case .clear:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? true
            hh = height ?? 8
        case .white:
            corner = corners ?? (0, [])
            isLineHidden = hideLine ?? true
            isViewHidden = hideView ?? false
            hh = height ?? 8
        }
        if height != nil {
            hh = height!
        }
        let rowCell = TCFormCellModel<WorkbenchTitleCell>.init(data: title, config: (corner, isLineHidden, isViewHidden), frameh: hh)
        return [rowCell]
    }
    
    func makeFirstGridCellForm(_ arr:[(String, String)], titleStr:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<WorkbenchFirstGridCell>.init(data: arr, frameh: UITableView.automaticDimension) { [weak self] back in
            guard let weakSelf = self else { return }
            if let txt = back as? String {
                weakSelf.didSelect(txt, titleStr: titleStr)
            }
        }
        return [rowCell]
    }
    
    func makeSecondGridCellForm(_ arr:[(String, String)], titleStr:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<WorkbenchSecondGridCell>.init(data: arr, frameh: UITableView.automaticDimension) { [weak self] back in
            guard let weakSelf = self else { return }
            if let txt = back as? String {
                weakSelf.didSelect(txt, titleStr: titleStr)
            }
        }
        return [rowCell]
    }
    
    func makeGridCellForms(array:[(String,String)], step:Int = 4, titleStr:String, type:Int) -> [TCCellBaseProtocol] {
        var newForms:[TCCellBaseProtocol] = []
        var finalArray:[[(String,String)]] = []
        var arr:[(String,String)] = []
        for item in array {
            arr.append(item)
        }
        if arr.count > step {
            finalArray = self.strideArray(array: arr, step: step)
        }else{
            finalArray = [arr]
        }
        for (i,item) in finalArray.enumerated() {
            if i > 0 {
                newForms += makeTitleCellForm(type: .white)
            }
            switch type {
            case 1:
                newForms += makeFirstGridCellForm(item, titleStr: titleStr)
            case 2:
                newForms += makeSecondGridCellForm(item, titleStr: titleStr)
            default:
                break
            }
        }
        return newForms
    }
    
    func strideArray(array:[(String,String)], step:Int) -> [[(String,String)]] {
        var finalArray = stride(from: 0, to: array.endIndex - (array.endIndex % step), by: step).map {
            Array(array[$0...$0+(step - 1)])
        }

        //取余，上面的操作只会等分，后面部分会被舍弃，需要重新加回
        if  array.count % step > 0{
            let a = Array(array[(step*finalArray.count)...(array.count - 1)])
            finalArray.append(a)
        }
        return finalArray
    }
    
    func showArray(sendpayArr:[String], allArr:[(String, String)], arrAll1Count:Int = 0) -> [(String, String)] {
        var arr:[(String, String)] = []
        for (i,item) in allArr.enumerated() {
            if sendpayArr.count > i+arrAll1Count, sendpayArr[i+arrAll1Count] == "0" {
                arr.append(item)
            }
        }
        return arr
    }
}
extension WorkbenchVm {
    func didSelect(_ txt:String, titleStr:String) {
        print(txt)
        switch txt {
        case "工单列表".languageString():
            if flushTable == 2 {
                searchOrder(40, titleStr: txt)
            }else{
                searchOrder(0, titleStr: txt)
            }
        case "退换管理".languageString():
            exchangeSearch()
        case "寄修管理".languageString():
            sendRepairSearch()
        case "现场建单".languageString():
            newCreateOrder()
        case "设备追溯".languageString():
            barcodeHistorySearch()
        case "工单统计".languageString():
            orderStatistics()
        case "一屏一码".languageString():
            break
        case "申请列表".languageString():
            applySearch(0)
        case "配件BOM".languageString():
            bomSearch()
        case "核销列表".languageString():
            returnSearch(0)
        case "配件库存".languageString():
            partsInvSearch(0)
        case "服务商库存".languageString():
            partsInvSearch(1)
        case "总部库存".languageString():
            partsInvSearch(2)
        case "配件额度".languageString():
            switch flushTable {
            case 1://服务人员工作台
                break
            case 2://企业用户工单台
                break
            default:
                break
            }
        case "发起结算".languageString():
            settlePage()
        case "结算单".languageString():
            settleSearch(0)
        case "考核单".languageString():
            checkBillSearch(0)
        case "统收统付".languageString():
            break
        case "不结算工单".languageString():
            searchOrder(22, titleStr: txt)
        case "工程任务".languageString():
            engineeringTaskSearch(0)
        case "待预约".languageString():
            searchOrder(2, titleStr: txt)
        case "待上门".languageString():
            searchOrder(4, titleStr: txt)
        case "待完工".languageString():
            searchOrder(5, titleStr: txt)
        case "待确认".languageString():
            switch titleStr {
            case "工单台".languageString():
                searchOrder(7, titleStr: txt)
            case "结算台".languageString():
                settleSearch(1)
            default:
                break
            }
        case "等待备件".languageString():
            searchOrder(6, titleStr: txt)
        case "送修中".languageString():
            searchOrder(8, titleStr: txt)
        case "退换中".languageString():
            searchOrder(9, titleStr: txt)
        case "待申诉".languageString():
            searchOrder(11, titleStr: txt)
        case "申请待发货".languageString():
            applySearch(2)
        case "已发货待签收".languageString():
            applySearch(3)
        case "旧件待核销".languageString():
            waitReturnOrderSearch()
        case "考核申诉".languageString():
            checkBillSearch(1)
        case "待开发票".languageString():
            settleSearch(2)
//        case "到款确认":
//            break
        case "今日任务".languageString():
            engineeringTaskSearch(1)
        case "执行中任务".languageString():
            engineeringTaskSearch(2)
        case "待派工".languageString():
            searchOrder(41, titleStr: txt)
        case "完工审核".languageString():
            searchOrder(42, titleStr: txt)
        case "待申诉审核".languageString():
            searchOrder(43, titleStr: txt)
        case "待审核".languageString():
            applySearch(1)
        case "待发货".languageString():
            applySearch(2)
        case "核销待审核".languageString():
            returnSearch(1)
        case "申诉待审核".languageString():
            checkBillSearch(2)
//        case "结算待审核":
//            break
        default:
            break
        }
    }
    
    
    //搜索工单
    //searchType:搜索类型(0所有/工单列表;1新单(待接单);2待预约;3待派工(待转派);4待上门;5待完工;6待备件;7完工确认;8送修中;9退换中;10已完成;11待申诉[服务人员工作台有用到];20处理中[首页有用到];21异常单[首页有用到];22不结算工单[服务人员工作台有用到]);40所有/工单列表;41待派工(服务商);42待完工审核;43待申诉审核;[40以后的在企业人员工作台有用到]
    func searchOrder(_ searchType:Int, titleStr:String) {
        let vc = UIStoryboard(name: "Home", bundle: nil).instantiateViewController(withIdentifier: "HomeOrderListSearchVc") as! HomeOrderListSearchVc
        vc.hidesBottomBarWhenPushed = true
        vc.searchType = String(searchType) 
        CD.visibleVC?.navigationController?.pushViewController(vc, animated: true)
    }
    
    //退换管理
    func exchangeSearch() {
        switch flushTable {
        case 1://服务人员工作台
            break
        case 2://企业用户工单台
            break
        default:
            break
        }
    }
    
    //寄修管理
    func sendRepairSearch() {
        switch flushTable {
        case 1://服务人员工作台
            break
        case 2://企业用户工单台
            break
        default:
            break
        }
    }
    
    //现场建单
    func newCreateOrder() {
        let creatOrderVc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "CreatOrderHomeVc") as! CreatOrderHomeVc
        creatOrderVc.hidesBottomBarWhenPushed = true
        CD.visibleVC?.navigationController?.pushViewController(creatOrderVc, animated: true)
    }
    
    //设备追溯
    func barcodeHistorySearch() {
        let barcodeVc = UIStoryboard(name: "CreatOrder", bundle: nil).instantiateViewController(withIdentifier: "BarcodeCheckVc") as! BarcodeCheckVc
        barcodeVc.hidesBottomBarWhenPushed = true
        CD.visibleVC?.navigationController?.pushViewController(barcodeVc, animated: true)
        
    }
    
    //工单统计
    func orderStatistics() {
        let requsetUrl = TWOCNetwork.shareNetManager().baseURL+"/h5/orderStatistics.html"
        let webUrl = requsetUrl + "?siteId="+MyInfo.shareInstance().siteId+"&engineerId="+MyInfo.shareInstance().engineerId+"&token="+MyInfo.shareInstance().token
        R_Web.push(.http(webUrl), title: "工单统计".languageString())
    }
    
    //配件申请列表
    //searchType:搜索类型(0所有;1待审核;2待发货;3待签收)
    func applySearch(_ searchType:Int) {
        R_PartsManagementMain.router(searchType, callback: nil)
    }
    
    //配件核销(也叫返厂/退回)列表
    //searchType:搜索类型(0所有;1待审核;2待核销;)
    func returnSearch(_ searchType:Int) {
        R_PartsReturnMain.router(searchType, callback: nil)
    }
    //待核销工单(旧件待退回)列表
    func waitReturnOrderSearch() {
        R_OldPartsToBeReturnedList.router(0, callback: nil)
    }
    
    //配件库存查询:0配件库存；1服务商库存；2总部库存
    func partsInvSearch(_ searchType:Int) {
        R_PartsInventorySearch.router(searchType)
    }
    
    //配件BOM查询
    func bomSearch() {
        R_PartsBomSearch.router()
    }
    
    //发起结算
    func settlePage() {
        R_SettlementAmountGet.router { reload in
            if reload {
                //去刷新结算单列表
                R_SettlementApplyMain.router(["index":1]) { t in
                    
                }
            }
        }
    }
    
    //结算单列表
    //searchType:搜索类型(0所有;1待确认;2待开票;3已结算)
    func settleSearch(_ searchType:Int) {
        R_SettlementApplyMain.router(["index":searchType]) { t in
            
        }
    }
    
    //考核单列表
    //searchType:搜索类型(0所有;1待申诉;2申诉待审核;)
    func checkBillSearch(_ searchType:Int) {
        R_SettlementCheckOrderMain.router(["index":searchType]) { a in
            
        }
    }
    
    //工程任务？？？
    func engineeringTaskSearch(_ searchType:Int) {
        
    }
}
extension WorkbenchVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["flushTable"] = flushTable   //工作台类型:1服务人员工作台;2企业用户工单台;(必传)

        let cNet = TWOCNetwork(url: "/app/v2/workTable/flush",andParam: par)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            if let data = result["data"] as? [String:Any] {
                weakSelf.model = M_Workbench(data)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
//        cNet.isJsonContentType = false
        cNet.postRequest()

    }
}
