//
//  M_OldPartsToBeReturnedList.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/7.
//

import Foundation

class M_OldPartsToBeReturnedList: NSObject {
    var orderId = ""             //工单ID);
    var orderNo = ""             //工单号);
    var stat = ""             //状态);
    var statName = ""             //状态名称);
    var returnButton = 0             //是否放出退回按钮：0否1是,为1时则显示界面中的“退回”按钮);
    var partsList:[Parts] = []             //list2);//配件明细
    
    init(_ data:[String:Any] = [:]) {
        orderId = data.stringValue(forKey: "orderId")
        orderNo = data.stringValue(forKey: "orderNo")
        stat = data.stringValue(forKey: "stat")
        statName = data.stringValue(forKey: "statName")
        returnButton = data.intValue(forKey: "returnButton")
        partsList = data.arrayValue(forKey: "partsList").compactMap({Parts($0)})
    }
    
    struct Parts {
        var orderPartsId = ""             //工单配件明细ID);
        var oldPartsId = ""             //配件ID);
        var pic = ""             //图片,后台返回空值时,前端使用默认图片显示);
        var oldPartsName = ""             //配件名称);
        var oldPartsCode = ""             //配件编码);
        var qty = ""             //待退回数量);
        var returnQty = ""             //已退回数量);
        
        var num = 0              //本次退回数量
        init(_ data:[String:Any] = [:]) {
            orderPartsId = data.stringValue(forKey: "orderPartsId")
            oldPartsId = data.stringValue(forKey: "oldPartsId")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            oldPartsName = data.stringValue(forKey: "oldPartsName")
            oldPartsCode = data.stringValue(forKey: "oldPartsCode")
            qty = data.stringValue(forKey: "qty")
            returnQty = data.stringValue(forKey: "returnQty")
        }
        
        func jsonValue() -> [String:Any] {
            var dic:[String:Any] = [:]
            dic["orderPartsId"] = orderPartsId
            dic["oldPartsId"] = oldPartsId
            dic["qty"] = num
            return dic
        }
    }

}
