//
//  M_PartsApplyDetail.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/22.
//

import Foundation

class M_PartsApplyDetail: NSObject {
    
    var stat = ""           //状态);
    var statName = ""           //状态名称);
    var applyTypeName = ""           //申请类型名称);
    var applyId = ""           //配件申请单ID);
    var applyNo = ""           //配件申请单号);
    var siteName = ""           //申请单位);
    var applyDate = ""           //申请时间);
    var deliverMan = ""           //收货人);
    var deliverMobile = ""           //联系电话);
    var deliverProvince = ""           //收货信息:省);
    var deliverCity = ""           //收货信息:市);
    var deliverCounty = ""           //收货信息:区);
    var delieverTown = ""           //收货信息:镇);
    var deliverAddress = ""           //收货详细地址);
    var applyQtyAll = ""           //申请数量);
    var remark = ""           //申请备注);
    var pic1 = ""           //凭证图片1);
    var pic2 = ""           //凭证图片2);
    var pic3 = ""           //凭证图片3);
    var picArr:[String] = []

    var outType = ""           //发出类型:1总部;2区域);
    var outWarehouseName = ""           //发出仓库名称);
    var deliverTypeName = ""           //配送方式名称);

    var deliverCompanyName = ""           //物流公司名称);
    var deliverNo = ""           //物流单号);

    var partsList:[Parts] = []     //配件列表
         

    //因为每个企业,每种单据,每个用户的操作都是不一样,或者后期会新增新的操作按钮,为了简化前端对操作按钮的控制,将逻辑放到后台来处理,由后台返回可展示的操作按钮列表,前端依次显示出来(但是每个按钮绑定的跳转页面只能在前端根据buttonCode写死);
    var operateButtonList:[OperateButton] = []             //操作按钮列表(前端依次显示buttonName)
         

    init(_ data:[String:Any] = [:]) {
        stat = data.stringValue(forKey: "stat")
        statName = data.stringValue(forKey: "statName")
        applyTypeName = data.stringValue(forKey: "applyTypeName")
        applyId = data.stringValue(forKey: "applyId")
        applyNo = data.stringValue(forKey: "applyNo")
        siteName = data.stringValue(forKey: "siteName")
        applyDate = data.stringValue(forKey: "applyDate")
        deliverMan = data.stringValue(forKey: "deliverMan")
        deliverMobile = data.stringValue(forKey: "deliverMobile")
        deliverProvince = data.stringValue(forKey: "deliverProvince")
        deliverCity = data.stringValue(forKey: "deliverCity")
        deliverCounty = data.stringValue(forKey: "deliverCounty")
        delieverTown = data.stringValue(forKey: "delieverTown")
        deliverAddress = data.stringValue(forKey: "deliverAddress")
        applyQtyAll = data.stringValue(forKey: "applyQtyAll")
        remark = data.stringValue(forKey: "remark")
        pic1 = data.stringValue(forKey: "pic1")
        pic2 = data.stringValue(forKey: "pic2")
        pic3 = data.stringValue(forKey: "pic3")
        picArr = []
        if !pic1.isEmpty {
            picArr.append(kGetServerPicUrl(pic1))
        }
        if !pic2.isEmpty {
            picArr.append(kGetServerPicUrl(pic2))
        }
        if !pic3.isEmpty {
            picArr.append(kGetServerPicUrl(pic3))
        }

        outType = data.stringValue(forKey: "outType")
        outWarehouseName = data.stringValue(forKey: "outWarehouseName")
        deliverTypeName = data.stringValue(forKey: "deliverTypeName")

        deliverCompanyName = data.stringValue(forKey: "deliverCompanyName")
        deliverNo = data.stringValue(forKey: "deliverNo")

        partsList = data.arrayValue(forKey: "partsList").compactMap({Parts($0)})
        operateButtonList = data.arrayValue(forKey: "operateButtonList").compactMap({OperateButton($0)})
    }
    
    struct Parts {
        var lineId = ""           //明细ID);
        var orderId = ""           //工单ID);//前端不显示
        var partsId = ""           //配件ID);
        var pic = ""           // 图片,后台返回空值时,前端使用默认图片显示);
        var partsName = ""           //配件名称);
        var partsCode = ""           //配件编码);
        var applyQty = ""           //申请数量);
        var applyAmount = ""           //申请金额);
        var checkQty = ""           //审核数量);
        var checkAmount = ""           //审核金额);
        var outQty = ""           //出库数量);
        var outAmount = ""           //出库金额);
        var getQty = ""           //收货数量);
        var getAmount = ""           //收货金额);
        
        var invQty = ""            //可用库存
        var outWarehouseId = ""
        var outWarehouseName = ""
        
        var qty = 0
        init(_ data:[String:Any] = [:]) {
            lineId = data.stringValue(forKey: "lineId")
            orderId = data.stringValue(forKey: "orderId")
            partsId = data.stringValue(forKey: "partsId")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            partsName = data.stringValue(forKey: "partsName")
            partsCode = data.stringValue(forKey: "partsCode")
            applyQty = data.stringValue(forKey: "applyQty")
            applyAmount = data.stringValue(forKey: "applyAmount")
            checkQty = data.stringValue(forKey: "checkQty")
            checkAmount = data.stringValue(forKey: "checkAmount")
            outQty = data.stringValue(forKey: "outQty")
            outAmount = data.stringValue(forKey: "outAmount")
            getQty = data.stringValue(forKey: "getQty")
            getAmount = data.stringValue(forKey: "getAmount")
            
            invQty = data.stringValue(forKey: "invQty")
            outWarehouseId = data.stringValue(forKey: "outWarehouseId")
            outWarehouseName = data.stringValue(forKey: "outWarehouseName")
        }
        
        func jsonValue() -> [String:Any] {
            var dic:[String:Any] = [:]
            dic["lineId"] = lineId
            dic["orderId"] = orderId
            dic["partsId"] = partsId
            dic["pic"] = pic
            dic["partsName"] = partsName
            dic["partsCode"] = partsCode
            dic["applyQty"] = applyQty
            dic["applyAmount"] = applyAmount
            dic["checkQty"] = checkQty
            dic["checkAmount"] = checkAmount
            dic["outQty"] = outQty
            dic["outAmount"] = outAmount
            dic["getQty"] = getQty
            dic["getAmount"] = getAmount
            return dic
        }
        
        func operationJsonValue(typeStr:String) -> [String:Any] {
            var dic:[String:Any] = [:]
            dic["lineId"] = lineId
            dic["partsId"] = partsId
            dic[typeStr] = qty
            return dic
        }
    }
    
    struct OperateButton {
        var buttonCode = ""           //按钮编码);//用于惟一标识操作类型
        var buttonName = ""           //按钮名称);//同一个操作,不同的企业可能叫法上不一样
        
        init(_ data:[String:Any] = [:]) {
            buttonCode = data.stringValue(forKey: "buttonCode")
            buttonName = data.stringValue(forKey: "buttonName")
        }
    }
}
