//
//  M_PartsManagementList.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/21.
//

import Foundation

class M_PartsManagementList: NSObject {
    var allQty = ""      //全部数量
    var unCheckPartsQty = ""      //待审核数量
    var unDeliveryPartsQty = ""      //待发货数量
    var unSignPartsQty = ""      //待签收数量
    
    var applyList:[Parts] = []     //配件申请列表
    
    init(_ data:[String:Any] = [:]) {
        allQty = data.stringValue(forKey: "allQty")
        unCheckPartsQty = data.stringValue(forKey: "unCheckPartsQty")
        unDeliveryPartsQty = data.stringValue(forKey: "unDeliveryPartsQty")
        unSignPartsQty = data.stringValue(forKey: "unSignPartsQty")
        applyList = data.arrayValue(forKey: "applyList").compactMap({Parts($0)})
    }
    
    struct Parts {
        var applyId = ""         //申请单ID
        var applyNo = ""         //申请单号
        var applyTypeName = ""         //申请类型名称
        var stat = ""         //状态
        var statName = ""         //状态名称
        var siteName = ""         //申请单位
        var applyDate = ""         //申请时间
        var applyQtyAll = ""         //申请数量
        var remark = ""         //申请备注
        
        init(_ data:[String:Any] = [:]) {
            applyId = data.stringValue(forKey: "applyId")
            applyNo = data.stringValue(forKey: "applyNo")
            applyTypeName = data.stringValue(forKey: "applyTypeName")
            stat = data.stringValue(forKey: "stat")
            statName = data.stringValue(forKey: "statName")
            siteName = data.stringValue(forKey: "siteName")
            applyDate = data.stringValue(forKey: "applyDate")
            applyQtyAll = data.stringValue(forKey: "applyQtyAll")
            remark = data.stringValue(forKey: "remark")
        }
    }
         

}
