//
//  M_PartsReturnDetail.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/27.
//

import Foundation

class M_PartsReturnDetail: NSObject {
    
    var stat = ""           //状态
    var statName = ""           //状态名称
    var returnTypeName = ""           //返厂类型名称
    var inStatName = ""           //入库状态名称
    var returnId = ""           //返厂单ID
    var returnNo = ""           //返厂单号
    var siteName = ""           //退回单位
    var applyDate = ""           //返厂时间
    var deliverMan = ""           //发出人
    var deliverMobile = ""           //发出人电话
//    var deliverProvince = ""           //收货信息:省);
//    var deliverCity = ""           //收货信息:市);
//    var deliverCounty = ""           //收货信息:区);
//    var delieverTown = ""           //收货信息:镇);
    var deliverAddress = ""           //发出地址
    var returnQtyAll = ""           //数量
    var remark = ""           //备注

    var deliverTypeName = ""           //配送方式名称
    var deliverCompanyName = ""           //物流公司名称
    var deliverNo = ""           //物流单号

    var partsList:[Parts] = []     //配件列表
         

    //因为每个企业,每种单据,每个用户的操作都是不一样,或者后期会新增新的操作按钮,为了简化前端对操作按钮的控制,将逻辑放到后台来处理,由后台返回可展示的操作按钮列表,前端依次显示出来(但是每个按钮绑定的跳转页面只能在前端根据buttonCode写死);
    var operateButtonList:[OperateButton] = []             //操作按钮列表(前端依次显示buttonName)


    init(_ data:[String:Any] = [:]) {
        stat = data.stringValue(forKey: "stat")
        statName = data.stringValue(forKey: "statName")
        returnTypeName = data.stringValue(forKey: "returnTypeName")
        inStatName = data.stringValue(forKey: "inStatName")
        returnId = data.stringValue(forKey: "returnId")
        returnNo = data.stringValue(forKey: "returnNo")
        siteName = data.stringValue(forKey: "siteName")
        applyDate = data.stringValue(forKey: "applyDate")
        deliverMan = data.stringValue(forKey: "deliverMan")
        deliverMobile = data.stringValue(forKey: "deliverMobile")
//        deliverProvince = data.stringValue(forKey: "deliverProvince")
//        deliverCity = data.stringValue(forKey: "deliverCity")
//        deliverCounty = data.stringValue(forKey: "deliverCounty")
//        delieverTown = data.stringValue(forKey: "delieverTown")
        deliverAddress = data.stringValue(forKey: "deliverAddress")
        returnQtyAll = data.stringValue(forKey: "returnQtyAll")
        remark = data.stringValue(forKey: "remark")
        
        deliverTypeName = data.stringValue(forKey: "deliverTypeName")

        deliverCompanyName = data.stringValue(forKey: "deliverCompanyName")
        deliverNo = data.stringValue(forKey: "deliverNo")

        partsList = data.arrayValue(forKey: "partsList").compactMap({Parts($0)})
        operateButtonList = data.arrayValue(forKey: "operateButtonList").compactMap({OperateButton($0)})
    }
    
    struct Parts {
        var lineId = ""           //明细ID
        var partsId = ""           //配件ID
        var pic = ""           // 图片,后台返回空值时,前端使用默认图片显示
        var partsName = ""           //配件名称
        var partsCode = ""           //配件编码
        var returnQty = ""           //退回数量
        var returnAmount = ""           //退回金额
        var inQty = ""           //核销数量
        var inAmount = ""          //核销金额
        var orderId = ""           //关联工单ID
        var orderNo = ""           //关联工单号
        
        var qty = 0
        init(_ data:[String:Any] = [:]) {
            lineId = data.stringValue(forKey: "lineId")
            partsId = data.stringValue(forKey: "partsId")
            pic = kGetServerPicUrl(data.stringValue(forKey: "pic"))
            partsName = data.stringValue(forKey: "partsName")
            partsCode = data.stringValue(forKey: "partsCode")
            returnQty = data.stringValue(forKey: "returnQty")
            returnAmount = data.stringValue(forKey: "returnAmount")
            inQty = data.stringValue(forKey: "inQty")
            inAmount = data.stringValue(forKey: "inAmount")
            orderId = data.stringValue(forKey: "orderId")
            orderNo = data.stringValue(forKey: "orderNo")
        }
        
        func jsonValue() -> [String:Any] {
            var dic:[String:Any] = [:]
            dic["lineId"] = lineId
            dic["partsId"] = partsId
            dic["pic"] = pic
            dic["partsName"] = partsName
            dic["partsCode"] = partsCode
            dic["returnQty"] = returnQty
            dic["returnAmount"] = returnAmount
            dic["inQty"] = inQty
            dic["inAmount"] = inAmount
            dic["orderId"] = orderId
            dic["orderNo"] = orderNo
            return dic
        }
        
        func operationJsonValue(typeStr:String) -> [String:Any] {
            var dic:[String:Any] = [:]
            dic["lineId"] = lineId
            dic["partsId"] = partsId
            dic[typeStr] = qty
            return dic
        }
    }
    
    struct OperateButton {
        var buttonCode = ""           //按钮编码);//用于惟一标识操作类型
        var buttonName = ""           //按钮名称);//同一个操作,不同的企业可能叫法上不一样
        
        init(_ data:[String:Any] = [:]) {
            buttonCode = data.stringValue(forKey: "buttonCode")
            buttonName = data.stringValue(forKey: "buttonName")
        }
    }
}
