//
//  M_PartsReturnList.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/27.
//

import Foundation

class M_PartsReturnList: NSObject {
    var allQty = ""      //全部数量
    var unCheckPartsQty = ""      //待审核数量
    var unInPartsQty = ""      //待核销数量
    
    var returnList:[Return] = []     //配件申请列表
    
    init(_ data:[String:Any] = [:]) {
        allQty = data.stringValue(forKey: "allQty")
        unCheckPartsQty = data.stringValue(forKey: "unCheckPartsQty")
        unInPartsQty = data.stringValue(forKey: "unInPartsQty")
        
        returnList = data.arrayValue(forKey: "returnList").compactMap({Return($0)})
    }
    
    struct Return {
        
        var returnId = ""         //返厂单ID);
        var returnNo = ""         //返厂单号);
        var returnTypeName = ""         //返厂类型名称);
        var stat = ""         //状态
        var statName = ""         //状态名称
        var siteName = ""         // 核销单位
        var applyDate = ""         //返厂(申请)时间
        var returnQtyAll = ""         //返厂数量);
        var remark = ""         //返厂备注
        
        init(_ data:[String:Any] = [:]) {
            returnId = data.stringValue(forKey: "returnId")
            returnNo = data.stringValue(forKey: "returnNo")
            returnTypeName = data.stringValue(forKey: "returnTypeName")
            stat = data.stringValue(forKey: "stat")
            statName = data.stringValue(forKey: "statName")
            siteName = data.stringValue(forKey: "siteName")
            applyDate = data.stringValue(forKey: "applyDate")
            returnQtyAll = data.stringValue(forKey: "returnQtyAll")
            remark = data.stringValue(forKey: "remark")
        }
    }
         

}
