//
//  PartsApplyDetailImagesCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/22.
//

import UIKit

class PartsApplyDetailImagesCell: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var img1: UIImageView!
    @IBOutlet weak var img2: UIImageView!
    @IBOutlet weak var img3: UIImageView!
    @IBOutlet weak var view1: UIView!
    @IBOutlet weak var view2: UIView!
    @IBOutlet weak var view3: UIView!
    @IBOutlet weak var btn1: UIButton!
    @IBOutlet weak var btn2: UIButton!
    @IBOutlet weak var btn3: UIButton!
    @IBOutlet weak var stack_images: UIStackView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        btn1.cd.tag(0)
        btn2.cd.tag(1)
        btn3.cd.tag(2)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}
extension PartsApplyDetailImagesCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, [String])
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        stack_images.cd.isHidden(data.1.isEmpty)
        view1.cd.isHidden(data.1.count < 1)
        view2.cd.isHidden(data.1.count < 2)
        view3.cd.isHidden(data.1.count < 3)
        guard !data.1.isEmpty else {
            return
        }
        img1.sd_setImage(with: URL(string: data.1[0]), placeholderImage: UIImage(named: "parts_default"))
        guard data.1.count > 1 else {
            return
        }
        img2.sd_setImage(with: URL(string: data.1[1]), placeholderImage: UIImage(named: "parts_default"))
        guard data.1.count > 2 else {
            return
        }
        img3.sd_setImage(with: URL(string: data.1[2]), placeholderImage: UIImage(named: "parts_default"))
        
    }
    
    func row_update(config data: ConfigModel) {
        
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
}
