//
//  PartsApplyOperationAmountsCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/23.
//

import UIKit

class PartsApplyOperationAmountsCell: UITableViewCell {

    @IBOutlet weak var lab_value1: UILabel!
    @IBOutlet weak var lab_value2: UILabel!
    @IBOutlet weak var lab_value3: UILabel!
    @IBOutlet weak var lab_value4: UILabel!
    
    @IBOutlet weak var lab_title1: UILabel!
    @IBOutlet weak var lab_title2: UILabel!
    @IBOutlet weak var lab_title3: UILabel!
    @IBOutlet weak var lab_title4: UILabel!
    
    @IBOutlet weak var stack_first: UIStackView!
    @IBOutlet weak var stack_second: UIStackView!
    @IBOutlet weak var view_content: UIView!
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        view_content.cd.gradient(layerAxial: [(Config.color.hex("#ECF3FE"), Float(0)), (Config.color.hex("f"), Float(1))], point: (CGPoint(x: 0.50, y: 0.00), CGPoint(x: 0.50, y: 1.00)))
    }
}
extension PartsApplyOperationAmountsCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String, String)
    typealias ConfigModel = (String, String, String, String)
    
    func row_update(dataSource data: DataSource) {
        lab_value1.cd.text(!data.0.isEmpty ? data.0 : "0")
        lab_value2.cd.text(!data.1.isEmpty ? data.1 : "0")
        lab_value3.cd.text(!data.2.isEmpty ? data.2 : "0")
        lab_value4.cd.text(!data.3.isEmpty ? data.3 : "0")
    }
    
    func row_update(config data: ConfigModel) {
        lab_title1.cd.text(data.0)
        lab_title2.cd.text(data.1)
        lab_title3.cd.text(data.2)
        lab_title4.cd.text(data.3)
        stack_second.cd.isHidden(data.2.isEmpty && data.3.isEmpty)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
    }
}

