//
//  PartsApplyOperationItemCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/23.
//

import UIKit

class PartsApplyOperationItemCell: UITableViewCell {

    @IBOutlet weak var img_part: UIImageView!
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_code: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension PartsApplyOperationItemCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        img_part.sd_setImage(with: URL(string: data.0), placeholderImage: UIImage(named: "parts_default"))
        lab_name.cd.text(data.1)
        lab_code.cd.text("\("配件编码".languageString())：\(data.2)")
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func row_update(callBack block: TCRowCallBack?) {
    }
}
