//
//  PartsManagementListInfoCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/21.
//

import UIKit

class PartsManagementListInfoCell: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_detail: UILabel!
    @IBOutlet weak var width_title: NSLayoutConstraint!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension PartsManagementListInfoCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        lab_detail.cd.text(data.1)
    }
    
    func row_update(config data: ConfigModel) {
        if let ww = data as? CGFloat {
            width_title.constant = ww
        }
        if let data = data as? (CGFloat, UIColor, UIColor) {
            width_title.constant = data.0
            lab_title.cd.text(data.1)
            lab_detail.cd.text(data.2)
        }
    }
}
