//
//  PartsManagementListTitleCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/21.
//

import UIKit

class PartsManagementListTitleCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_stat: UILabel!
    @IBOutlet weak var img_type: UIImageView!
    @IBOutlet weak var lab_type: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override func draw(_ rect: CGRect) {
        super.draw(rect)
        bgView.makeRadius(value: 8, type: [.topLeft, .topRight])
    }
}
extension PartsManagementListTitleCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        lab_stat.cd.text(data.1)
        lab_type.cd.text(" \(data.2) ")
            .isHidden(data.2.isEmpty)
    }
    
    func row_update(config data: ConfigModel) {
        if let data = data as? UIColor {
            lab_type.cd.background(data)
        }
    }
}
