//
//  VTSubmitButtonCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/8.
//

import UIKit

class VTSubmitButtonCell: UITableViewCell {
    @IBOutlet weak var btn: UIButton!
    @IBOutlet weak var height_Btn: NSLayoutConstraint!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        btn.cd.text("查询".languageString())
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}
extension VTSubmitButtonCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = String
    typealias ConfigModel = CGFloat
    
    func row_update(dataSource data: DataSource) {
        btn.cd.text(data.languageString())
    }
    
    func row_update(config data: ConfigModel) {
        height_Btn.constant = data
        btn.cd.corner(data/2)
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        self.callBack = block
    }
}
