//
//  PartsApplyCheckVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/25.
//

import UIKit

public struct R_PartsApplyCheck {
    static func router(_ applyId: String, outWarehouseName:String, partsList:[M_PartsApplyDetail.Parts], callBack:((Bool)->Void)?) {
        let vc = PartsApplyCheckVc.cd_storyboard("PartsManagement", from: "PartsApplyCheckVc") as! PartsApplyCheckVc
        vc.vm.applyId = applyId
        vc.vm.partsList = partsList
        vc.vm.outWarehouseName = outWarehouseName
        vc.vm.callBack = callBack
        CD.push(vc)
    }
}

class PartsApplyCheckVc: UIViewController {

    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var view_btns: UIView!
    
    @IBOutlet weak var btn_submit: UIButton!
    
    var vm = PartsApplyCheckVm()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        makeUI()
        vm.makeForms()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        setNavigationBackButton()
        self.title = "配件申请审核".languageString()
        btn_submit.cd.text("审核".languageString())
    }

    func makeUI() {
        vm.reloadData = {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.tableView.reloadData()
        }

        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.showsVerticalScrollIndicator = false
        tableView.showsHorizontalScrollIndicator = false
    }
    
    @IBAction func clickButton(_ sender: UIButton) {
        var qty = 0
        for item in vm.partsList {
            qty += item.qty
        }
        guard qty > 0 else {
            hud_info("至少一条本次审核数量>0".languageString())
            return
        }
        vm.requestApplyCheck()
    }
}

extension PartsApplyCheckVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}



