//
//  PartsBomSearchVc.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/9.
//

import UIKit
import MJRefresh

public struct R_PartsBomSearch {
    static func router() {
        let vc = PartsBomSearchVc.cd_storyboard("PartsManagement", from: "PartsBomSearchVc") as! PartsBomSearchVc
        CD.push(vc)
    }
}

class PartsBomSearchVc: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var tf_search: UITextField!
    @IBOutlet weak var btn_scan: UIButton!
    
    var vm = PartsBomSearchVm()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.setNavigationBackButton()
        self.title = "配件BOM".languageString()
        tf_search.placeholder = "输入关键词搜索".languageString()
        btn_scan.cd.text(" "+"扫码".languageString())
        makeUI()
        vm.makeForms()
        vm.requestData()
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        
    }

    func makeUI() {
        tf_search.delegate = self
        
        vm.reloadData = {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.tableView.reloadData()
        }
        vm.callBack = {[weak self] bool in
            guard let weakSelf = self else { return }
            if bool {
                weakSelf.headerRefresh()
            }
        }
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.showsVerticalScrollIndicator = false
        tableView.showsHorizontalScrollIndicator = false
        let header = MJRefreshNormalHeader()
        header.stateLabel.textColor = UIColor(hexString: "999999")
        header.setRefreshingTarget(self, refreshingAction: #selector(headerRefresh))
        tableView.mj_header = header
        
        let footer = MJRefreshAutoNormalFooter()
        footer.stateLabel.textColor = UIColor(hexString: "999999")
        footer.setRefreshingTarget(self, refreshingAction: #selector(footerRefresh))
        footer.isOnlyRefreshPerDrag = true
        tableView.mj_footer = footer
    }
    
    @objc func headerRefresh(){
        tableView.mj_header.endRefreshing()
        tableView.mj_footer.resetNoMoreData()
        vm.pageNumber = 1
        vm.requestData()
    }
    
    @objc func footerRefresh(){
        self.tableView.mj_footer.endRefreshing()
        if vm.pageCount < vm.pageSize{
            self.tableView.mj_footer.endRefreshingWithNoMoreData()
        }else{
            vm.pageNumber = vm.pageNumber + 1
            vm.requestData()
        }
    }
    
    @IBAction func scan(_ sender: UIButton) {
        let qrVC = QRViewController()
        qrVC.configResultCall {[weak self] code, errorStr in
            guard let weakSelf = self else {return}
            if errorStr != nil && errorStr != "" {
                CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                return
            }
            weakSelf.tf_search.text = code ?? ""
            weakSelf.vm.searchKey = code ?? ""
            weakSelf.headerRefresh()
        }
        let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
        qrNavigationC.modalPresentationStyle = .overFullScreen
        qrNavigationC.modalTransitionStyle = .crossDissolve
        self.present(qrNavigationC, animated: true, completion: nil)
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        vm.searchKey = sender.text!
        headerRefresh()
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
}

extension PartsBomSearchVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}
