//
//  PartsApplyCheckVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/25.
//

import Foundation

class PartsApplyCheckVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var partsList:[M_PartsApplyDetail.Parts] = []
    
    var applyId = ""
    
    var outWarehouseName = ""
    
    var callBack:((Bool)->Void)?
}

extension PartsApplyCheckVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        for (i, item) in partsList.enumerated() {
            newForms += makeLineCellForm(height: 8)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, corners: (8, [.layerMinXMinYCorner, .layerMaxXMinYCorner]),height: 12)
            newForms += makeItemCellForm(imgStr: item.pic, name: item.partsName, code: item.partsCode)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 6)
            newForms += makeAmountCellForm(data: item)
            newForms += makeOperationLineCellForm(contentColor: .clear, left3: 0, hh: 9)
            newForms += makeQuantityCellForm(data: item, idx: i)
        }
        newForms += makeLineCellForm(height: 8)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
    
    func makeItemCellForm(imgStr:String, name:String, code:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<PartsApplyOperationItemCell>.init(data: (imgStr, name, code),  frameh: UITableView.automaticDimension)
        return [rowCell]
    }
    
    func makeAmountCellForm(data:M_PartsApplyDetail.Parts, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<PartsApplyOperationAmountsCell>.init(data: (outWarehouseName, data.invQty, data.applyQty, data.checkQty), config: ("出库仓库".languageString(), "可用库存".languageString(), "申请数量".languageString(), "已审数量".languageString()),  frameh: 136)
        return [rowCell]
    }
    
    func makeQuantityCellForm(data:M_PartsApplyDetail.Parts,idx:Int) -> [TCCellBaseProtocol] {
        let maxQty = data.applyQty.intValue() - data.checkQty.intValue()
        let rowCell = TCFormCellModel<PartsApplyOperationQuantityCell>.init(data: ("\("本次审核".languageString())：", data.qty, maxQty), config: (8, [.bottomRight, .bottomRight]),frameh: UITableView.automaticDimension) { [weak self] back in
            guard let weakSelf = self else { return }
            if let qty = back as? Int {
                weakSelf.partsList[idx].qty = qty
                weakSelf.makeForms()
            }
        }
        return [rowCell]
    }
    
    func makeOperationLineCellForm(cellColor:UIColor = .clear, bgColor:UIColor = .white, contentColor:UIColor = Config.color.hex("f8"), lineColor:UIColor = Config.color.hex("e6"), left1:CGFloat = 12, left2:CGFloat = 12, left3:CGFloat = 12, corner:(CGFloat, UIRectCorner, Int) = (0,[],3), hh:CGFloat = 12) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderOperationLineCell>.init(data: (cellColor, bgColor, contentColor, lineColor ), config: (left1, left2, left3, corner),frameh: hh)
        return [rowCell]
    }
}



extension PartsApplyCheckVm {
    
    func requestApplyCheck() {
        var par:[String:Any] = [:]
        par["applyId"] = applyId
        par["partsList"] = partsList.compactMap({$0.operationJsonValue(typeStr: "checkQty")})

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/partsDo/applyCheck",andParam: par)
        cNet.successCall = {[weak self](result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_succeed("操作成功~".languageString())
            weakSelf.callBack?(true)
            CD.pop()
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}

