//
//  PartsReturnDetailVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/27.
//

import Foundation

class PartsReturnDetailVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var returnId = ""
    
    var model = M_PartsReturnDetail()
}

extension PartsReturnDetailVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 16)
        do{
            let rowCell = TCFormCellModel<PartsApplyDetailStatusCell>.init(data: ("icon_daizhifu", model.statName, model.returnTypeName, model.inStatName), frameh: UITableView.automaticDimension)
            newForms.append(rowCell)
        }
        newForms += makeLineCellForm(height: 24)
        do{
            let rowCell = TCFormCellModel<PartsApplyDetailNumCell>.init(data: (model.returnNo), frameh: 44)
            newForms.append(rowCell)
        }
        //MARK: ----申请信息
        newForms += makeTitleCellForm(titleStr: "退回信息".languageString())
        newForms += makeInfoCellForm(titleStr: "退回单位".languageString(), detailStr: model.siteName)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeInfoCellForm(titleStr: "返厂时间".languageString(), detailStr: model.applyDate)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeInfoCellForm(titleStr: "数      量".languageString(), detailStr: model.returnQtyAll)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeInfoCellForm(titleStr: "备      注".languageString(), detailStr: model.remark)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
        
        
        //MARK: ----发货信息
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "发货信息".languageString(), corner: (8, [.topLeft, .topRight]))
        newForms += makeInfoCellForm(titleStr: "发 出 人".languageString(), detailStr: "\(model.deliverMan)/\(model.deliverMobile)")
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeInfoCellForm(titleStr: "发出地址".languageString(), detailStr: model.deliverAddress)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
        newForms += makeInfoCellForm(titleStr: "配送方式".languageString(), detailStr: model.deliverTypeName)
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]),height: 12)
        
        
        //MARK: ----物流信息
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "物流信息".languageString(), corner: (8, [.topLeft, .topRight]))
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 12)
        do{
            let rowCell = TCFormCellModel<OrderPartsApplyLogisticsInfoCell>.init(data: (model.deliverCompanyName, model.deliverNo), frameh: UITableView.automaticDimension)
            newForms.append(rowCell)
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 16)
        
        
        
        //MARK: ------配件明细
        newForms += makeLineCellForm(height: 8)
        newForms += makeTitleCellForm(titleStr: "配件明细".languageString(), corner: (8, [.topLeft, .topRight]))
        for (i,item) in model.partsList.enumerated() {
            if i > 0 {
                newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white,height: 8)
            }
            newForms += makeOperationLineCellForm(lineColor: .clear,corner: (8, [.topLeft, .topRight], 2))
            newForms += makeItemCellForm(imgStr: item.pic, name: item.partsName, code: item.partsCode)
            newForms += makeOperationLineCellForm(lineColor: .clear,hh: 6)
            newForms += makeAmountCellForm(data: item, hh: 68)
            newForms += makeOperationLineCellForm(lineColor: .clear, hh: 12)
            do{
                let rowCell = TCFormCellModel<PartsReturnDetailRelationCell>.init(data: (item.orderNo), frameh: UITableView.automaticDimension)
                newForms.append(rowCell)
            }
//            newForms += makeOperationLineCellForm(lineColor: .clear, corner: (8, [.bottomLeft, .bottomRight], 2),hh: 12)
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12,bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 12)
        newForms += makeLineCellForm(height: 8)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
    
    func makeTitleCellForm(titleStr:String, statusStr:String = "", corner:(CGFloat, UIRectCorner) = (0,[]), isShowArrow:Bool = false, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderDetailTitleCell>.init(data: (titleStr, statusStr), config: (corner, isShowArrow, false), frameh: hh ?? UITableView.automaticDimension)
        return [rowCell]
    }
    
    func makeInfoCellForm(titleStr:String, detailStr:String) -> [TCCellBaseProtocol] {
        let ww = titleStr.getLabelWidth(h: 20, f: Config.font.fontRegular(14)) + 8
        let rowCell = TCFormCellModel<PartsManagementListInfoCell>.init(data: (titleStr, detailStr), config: ww, frameh: UITableView.automaticDimension)
        return [rowCell]
    }
    
    
    func makeItemCellForm(imgStr:String, name:String, code:String) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderPartsApplyListItemCell>.init(data: (imgStr, name, code),  frameh: UITableView.automaticDimension)
        return [rowCell]
    }
    
    func makeAmountCellForm(data:M_PartsReturnDetail.Parts, hh:CGFloat? = nil) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderPartsApplyListItemAmountCell>.init(data: (data),  frameh: hh == nil ? UITableView.automaticDimension : hh!)
        return [rowCell]
    }
    
    func makeOperationLineCellForm(cellColor:UIColor = .clear, bgColor:UIColor = .white, contentColor:UIColor = Config.color.hex("f8"), lineColor:UIColor = Config.color.hex("e6"), left1:CGFloat = 12, left2:CGFloat = 12, left3:CGFloat = 12, corner:(CGFloat, UIRectCorner, Int) = (0,[],3), hh:CGFloat = 12) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<OrderOperationLineCell>.init(data: (cellColor, bgColor, contentColor, lineColor ), config: (left1, left2, left3, corner),frameh: hh)
        return [rowCell]
    }
}

extension PartsReturnDetailVm {
    
    func requestDatas() {
        var par:[String:Any] = [:]
        par["returnId"] = returnId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/parts/getReturnDetail",andParam: par)
        cNet.successCall = {[weak self](result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            if let data = result["data"] as? [String:Any] {
                weakSelf.model = M_PartsReturnDetail(data)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}

