//
//  PartsReturnListVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/27.
//

import Foundation

class PartsReturnListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var searchType = 0       //搜索类型(0所有;1待审核;2待发货;3待签收)
    var searchKey = ""      //查询关键字(搜索时传入的关键字)
    var pageNumber = 1      //当前页
    var pageSize = 10        //每页大小
    var pageCount = 0
    
    var model = M_PartsReturnList()
    
    var callBack:((Bool)->Void)?
    
    var dataBack:((M_PartsReturnList)->Void)?
    
    var reloadList:(([Int])->Void)?
}

extension PartsReturnListVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        
        for (i,item) in model.returnList.enumerated(){
            newForms += makeLineCellForm(bgColor: Config.color.hex("f8"), height: 8)
            newForms += makeTitleCellForm(titleStr: item.returnNo, statStr: item.statName, typeStr: item.returnTypeName, idx: i)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 12, idx: i)
            newForms += makeInfoCellForm(titleStr: "退回单位".languageString(), detailStr: item.siteName, idx: i)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 4, idx: i)
            newForms += makeInfoCellForm(titleStr: "返厂时间".languageString(), detailStr: item.applyDate, idx: i)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 4, idx: i)
            newForms += makeInfoCellForm(titleStr: "返厂数量".languageString(), detailStr: item.returnQtyAll, idx: i)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, height: 4, idx: i)
            newForms += makeInfoCellForm(titleStr: "返厂备注".languageString(), detailStr: item.remark, idx: i)
            newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 12, idx: i)
        }
        newForms += makeLineCellForm(bgColor: Config.color.hex("f8"), height: 16)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12, idx:Int = -99) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func makeTitleCellForm(titleStr:String, statStr:String, typeStr:String, idx:Int) -> [TCCellBaseProtocol] {
        let rowCell = TCFormCellModel<PartsManagementListTitleCell>.init(data: (titleStr, statStr, typeStr), config: Config.color.hex("#FF6300"), frameh: UITableView.automaticDimension, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func makeInfoCellForm(titleStr:String, detailStr:String, idx:Int) -> [TCCellBaseProtocol] {
        let ww = titleStr.getLabelWidth(h: 20, f: Config.font.fontRegular(14)) + 8
        let rowCell = TCFormCellModel<PartsManagementListInfoCell>.init(data: (titleStr, detailStr), config: ww, frameh: UITableView.automaticDimension, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func didSelect(_ idx:Int) {
        guard idx >= 0 else {
            return
        }
        R_PartsReturnDetail.router(model.returnList[idx].returnId) {  [weak self] arr in
            guard let weakSelf = self else { return }
            if !arr.isEmpty {
                weakSelf.reloadList?(arr)
                weakSelf.pageNumber = 1
                weakSelf.requestData()
            }
        }
    }
}
extension PartsReturnListVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["searchType"] = searchType
        par["searchKey"] = searchKey
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/parts/returnSearch",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                let m = M_PartsReturnList(data)
                weakSelf.pageCount = m.returnList.count
                weakSelf.model.allQty = m.allQty
                weakSelf.model.unCheckPartsQty = m.unCheckPartsQty
                weakSelf.model.unInPartsQty = m.unInPartsQty
                if weakSelf.pageNumber == 1 {
                    weakSelf.model.returnList = m.returnList
                }else{
                    weakSelf.model.returnList += m.returnList
                }
                weakSelf.dataBack?(weakSelf.model)
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}


