//
//  PartsReturnRejectVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/27.
//

import Foundation

class PartsReturnRejectVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var returnId = ""
    var rejectRemark = ""        //驳回意见
    
    var callBack:((Bool)->Void)?
}

extension PartsReturnRejectVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        do{
            let rowCell = TCFormCellModel<OrderOperationSelectCell>.init(data: ("驳回意见".languageString(), "nil"), config: (true, true, (8, [.topLeft, .topRight])), frameh: UITableView.automaticDimension)
            newForms.append(rowCell)
        }
        do{
            let rowCell = TCFormCellModel<OrderOperationTextViewCell>.init(data: (rejectRemark), frameh: 104) {[weak self] back in
                guard let weakSelf = self else { return }
                if let txt = back as? String {
                    weakSelf.rejectRemark = txt
                    weakSelf.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        newForms += makeLineCellForm(leftW: 12, rightW: 12, bgColor: .white, corners: (8, [.layerMinXMaxYCorner, .layerMaxXMaxYCorner]), height: 12)
        newForms += makeLineCellForm(height: 8)
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 12) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
}

extension PartsReturnRejectVm {
    
    func requestReject() {
        var par:[String:Any] = [:]
        par["returnId"] = returnId
        par["rejectRemark"] = rejectRemark

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/partsDo/returnReject",andParam: par)
        cNet.successCall = {[weak self](result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_succeed("操作成功~".languageString())
            weakSelf.callBack?(true)
            CD.pop()
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}

