//
//  ServiceHomeNoticeCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/9.
//

import UIKit

class ServiceHomeNoticeCell: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_content: UILabel!
    @IBOutlet weak var lab_date: UILabel!
    @IBOutlet weak var view_point: UIView!
    @IBOutlet weak var width_date: NSLayoutConstraint!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension ServiceHomeNoticeCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String, Bool)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        
        view_point.cd.isHidden(data.3)
        
        lab_content.cd.text(deleteHTMLTagFor(Text: data.1))
        
        var dateStr = data.2
        if data.2.contains(":") {
            dateStr = data.2.cd_date()?.string("MM-dd") ?? data.2
        }
        lab_date.cd.text(dateStr)
        width_date.constant = dateStr.getLabelWidth(h: 20, f: Config.font.fontRegular(12)) + 2
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func deleteHTMLTagFor(Text t:String) -> String {
        return t.replacingOccurrences(of: "(?i)</?(\\w?)\\b[^<]*>", with: "", options: .regularExpression, range: nil)
    }
}
