//
//  ServiceKnowledgeListCell.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/12.
//

import UIKit

class ServiceKnowledgeListCell: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_date: UILabel!
    @IBOutlet weak var width_date: NSLayoutConstraint!
    @IBOutlet weak var lab_content: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}
extension ServiceKnowledgeListCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (String, String, String)
    typealias ConfigModel = Any
    
    func row_update(dataSource data: DataSource) {
        lab_title.cd.text(data.0)
        lab_date.cd.text(data.2)
        width_date.constant = data.2.getLabelWidth(h: 20, f: Config.font.fontRegular(14)) + 2
        
        lab_content.cd.text(deleteHTMLTagFor(Text:data.1))
    }
    
    func row_update(config data: ConfigModel) {
    }
    
    func deleteHTMLTagFor(Text t:String) -> String {
        return t.replacingOccurrences(of: "(?i)</?(\\w?)\\b[^<]*>", with: "", options: .regularExpression, range: nil)
    }
}
