//
//  ServiceFaultListVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/10.
//

import Foundation

class ServiceFaultListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var searchKey = ""      //查询关键字(搜索时传入的关键字)
    var pageNumber = 1      //当前页
    var pageSize = 20        //每页大小
    var pageCount = 0
    
    var models:[M_ServiceFault] = []
    
    var categoryId = ""       //产品分类ID
    var categoryCode = ""       //分类编码
    var categoryName = ""       //分类名称
}

extension ServiceFaultListVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        for (idx, item) in models.enumerated(){
            do{
                let rowCell = TCFormCellModel<ServiceFaultListCell>.init(data: (item.categoryName, item.faultName), frameh: 44, didSelect:  {[weak self] in
                    guard let weakSelf = self else { return }
                    weakSelf.didSelect(idx)
                })
                newForms.append(rowCell)
            }
            newForms += makeLineCellForm(height: 8)
        }
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 8, idx:Int = -99) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func didSelect(_ idx:Int) {
        guard idx >= 0 else {
            return
        }
        let m = models[idx]
        R_ServiceFaultSolution.router(m.faultId)
    }
}

extension ServiceFaultListVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["categoryId"] = categoryId
        par["searchKey"] = searchKey
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/support/getFaultList",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                let faultList = data.arrayValue(forKey: "faultList").compactMap({M_ServiceFault($0)})
                if weakSelf.pageNumber == 1 {
                    if faultList.isEmpty {
                        hud_info("没有故障数据".languageString())
                    }
                    weakSelf.models = faultList
                }else{
                    weakSelf.models += faultList
                }
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}



class M_ServiceFault: NSObject {
    var seq = ""        //序号
    var faultId = ""        //故障现象ID
    var faultName = ""        //故障现象名称
    var categoryName = ""        //产品分类名称

    init(_ data:[String:Any] = [:]) {
        seq = data.stringValue(forKey: "seq")
        faultId = data.stringValue(forKey: "faultId")
        faultName = data.stringValue(forKey: "faultName")
        categoryName = data.stringValue(forKey: "categoryName")
    }
}
