//
//  ServiceFaultSolutionVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/13.
//

import Foundation

class ServiceFaultSolutionVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var models:[M_ServiceFaultSolution] = []
    
    var faultId = ""
}

extension ServiceFaultSolutionVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        for (idx, item) in models.enumerated(){
            do{
                let rowCell = TCFormCellModel<ServiceFaultSolutionCell>.init(data: (item.reasonName, idx), frameh: 64, didSelect:  {[weak self] in
                    guard let weakSelf = self else { return }
                    weakSelf.didSelect(idx)
                })
                newForms.append(rowCell)
            }
            newForms += makeLineCellForm(height: 8)
        }
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 8, idx:Int = -99) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height, didSelect:  {[weak self] in
            guard let weakSelf = self else { return }
            weakSelf.didSelect(idx)
        })
        return [rowCell]
    }
    
    func didSelect(_ idx:Int) {
        guard idx >= 0 else {
            return
        }
        let m = models[idx]
        R_ServiceRepairMeasures.router(m.reasonId)
    }
}

extension ServiceFaultSolutionVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["faultId"] = faultId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/support/getReasonList",andParam: par)
        cNet.successCall = {[weak self](result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            if let data = result["data"] as? [String:Any] {
                let reasonList = data.arrayValue(forKey: "reasonList")
                if !reasonList.isEmpty {
                    weakSelf.models = reasonList.compactMap({M_ServiceFaultSolution($0)})
                    weakSelf.makeForms()
                }else{
                    hud_info("没有解决方案数据".languageString())
                }
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}



class M_ServiceFaultSolution: NSObject {
    var seq = ""        //序号
    var reasonId = ""        //故障原因ID
    var reasonName = ""        //故障原因名称

    init(_ data:[String:Any] = [:]) {
        seq = data.stringValue(forKey: "seq")
        reasonId = data.stringValue(forKey: "reasonId")
        reasonName = data.stringValue(forKey: "reasonName")
    }
}
