//
//  ServiceNoticeListVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/12.
//

import Foundation

class ServiceNoticeListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var pageNumber = 1      //当前页
    var pageSize = 20        //每页大小
    var pageCount = 0
    
    var models:[M_ServiceHome.Bulletin] = []
}

extension ServiceNoticeListVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        for item in models {
            do{
                let rowCell = TCFormCellModel<ServiceNoticeListCell>.init(data: (item.title, item.content, item.createTime, item.record != "0"), frameh: UITableView.automaticDimension, didSelect:  {[weak self] in
                    guard let weakSelf = self else { return }
                    if item.record == "0" {
                        weakSelf.readNotice(item.id)
                    }
//                    R_Web.push(.html(item.content), title: "详情")
                    let html5String = "<html>" +
                            "<head>" +
                            "<meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=0,viewport-fit=cover\"/>" +
                            "<style>" +
                            "img {width: 100%;height: auto;}" +
                            "video {width: 100%;height: auto;}" +
                            "</style>" +
                            "</head>" +
                            "<body>" +
                    item.content +
                            "</body>" +
                            "</html>"
                    let web = Vc_Web()
                    web.title = "详情".languageString()
                    web.webType = .html(html5String)
                    CD.push(web)
                })
                newForms.append(rowCell)
            }
            newForms += makeLineCellForm(height: 8)
        }
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 8, idx:Int = -99) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
}

extension ServiceNoticeListVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["pageNumber"] = pageNumber
        par["pageSize"] = pageSize

        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/support/getBulletinList",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                let bulletinList = data.arrayValue(forKey: "bulletinList").compactMap({M_ServiceHome.Bulletin($0)})
                if weakSelf.pageNumber == 1 {
                    if bulletinList.isEmpty {
                        hud_info("没有知识库数据".languageString())
                    }
                    weakSelf.models = bulletinList
                }else{
                    weakSelf.models += bulletinList
                }
                weakSelf.makeForms()
            }
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
    
    func readNotice(_ id:String) {
        var par:[String:Any] = [:]
        par["bulletinId"] = id
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/support/bulletinRecord",andParam: par)
        cNet.successCall = { [weak self] (result) in
            hud_hidden()
            guard let weakSelf = self else { return }
            weakSelf.requestData()
        }
        cNet.failCall = {[weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_hidden()
            hud_error(errorStr)
            weakSelf.makeForms()
        }
        cNet.postRequest()
    }
}
