//
//  ServiceRepairMeasuresVm.swift
//  VattiCSS
//
//  Created by WZR on 2023/10/13.
//

import Foundation

class ServiceRepairMeasuresVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var reloadData:(()->())?
    
    var models:[M_ServiceRepairMeasures] = []
    
    var reasonId = ""       //故障原因ID
}

extension ServiceRepairMeasuresVm {
    func makeForms() {
        var newForms:[TCCellBaseProtocol] = []
        newForms += makeLineCellForm(height: 8)
        for item in models{
            do{
                let rowCell = TCFormCellModel<ServiceRepairMeasuresCell>.init(data: (item.serviceTypeName, item.fixMethodName), frameh: 72)
                newForms.append(rowCell)
            }
            newForms += makeLineCellForm(height: 8)
        }
        
        forms = newForms
        reloadData?()
    }
    
    func makeLineCellForm(leftW:CGFloat = 0, rightW:CGFloat = 0, bgColor:UIColor = .clear, backGroundColor:UIColor = .clear, corners:(CGFloat, CACornerMask) = (0, []), height:CGFloat = 8, idx:Int = -99) -> [TCCellBaseProtocol] {
        let uiConfigModel = TCFormCellConfigModel.defaultModel()
            .bgColor(backGroundColor)
            .cornerMask(corners.1)
            .cornerRadius(corners.0)
        let rowCell = TCFormCellModel<TCLineCell>.init(data: (leftW, rightW, bgColor), config: uiConfigModel, frameh: height)
        return [rowCell]
    }
}

extension ServiceRepairMeasuresVm {
    func requestData() {
        var par:[String:Any] = [:]
        par["reasonId"] = reasonId
        hud_loading()
        let cNet = TWOCNetwork(url: "/app/v2/support/getFixMethodList",andParam: par)
        cNet.successCall = {[weak self](result) in
            guard let weakSelf = self else { return }
            hud_hidden()
            if let data = result["data"] as? [String:Any] {
                let fixMethodList = data.arrayValue(forKey: "fixMethodList")
                if !fixMethodList.isEmpty {
                    weakSelf.models = fixMethodList.compactMap({M_ServiceRepairMeasures($0)})
                    weakSelf.makeForms()
                }else{
                    hud_info("没有维修措施数据".languageString())
                }
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_hidden()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
}



class M_ServiceRepairMeasures: NSObject {
    var seq = ""        //序号
    var fixMethodId = ""        //维修措施ID
    var fixMethodName = ""        //维修措施名称
    var serviceTypeName = ""        //服务类型

    init(_ data:[String:Any] = [:]) {
        seq = data.stringValue(forKey: "seq")
        fixMethodId = data.stringValue(forKey: "fixMethodId")
        fixMethodName = data.stringValue(forKey: "fixMethodName")
        serviceTypeName = data.stringValue(forKey: "serviceTypeName")
    }
}
