//
//  Cell_SettlementApplyListHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/22.
//

import UIKit

class Cell_SettlementApplyListHeader: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var btn_state: UIButton!
    @IBOutlet weak var lab_serviceType: UILabel!
    @IBOutlet weak var btn_isUrgent: UIButton!
    @IBOutlet weak var width_btn_isUrgent: NSLayoutConstraint!
    
    @IBOutlet weak var btn_isTimeout: UIButton!
    @IBOutlet weak var btn_Time: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = UIColor(hexString: "f9f9f9")
        self.btn_Time.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
        self.btn_isTimeout.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_SettlementApplyListHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = ([String:Any])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: ([String:Any])) {
        lab_serviceType.text = data.stringValue("settleNo")
        btn_isTimeout.setTitle("时长", for: .normal)
        btn_Time.setTitle(data.stringValue("timeLable"), for: .normal)
        btn_state.setTitle(data.stringValue("statName"), for: .normal)
        
        width_btn_isUrgent.constant = 0
        btn_isUrgent.isHidden = true
        
        btn_isTimeout.isHidden = data.stringValue("timeLable") == ""
        btn_Time.isHidden = data.stringValue("timeLable") == ""
    }
    
}
