//
//  Cell_SettlementDetailHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/25.
//

import UIKit

class Cell_SettlementDetailHeader: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lab_state: UILabel!
    @IBOutlet weak var lab_date: UIButton!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.lab_date.contentEdgeInsets = UIEdgeInsets(top: 0,left: 5, bottom: 0,right: 5);
        
        bgView.cd.background(Config.color.hex("478BFF"))
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_SettlementDetailHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = ([String:Any])
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: ([String:Any])) {
        lab_state.text = data.stringValue(forKey: "statName")
        lab_date.setTitle(data.stringValue(forKey: "createTime"), for: .normal)
    }
    
}
