//
//  Cell_SettlementDetailInfoHeader.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/25.
//

import UIKit

class Cell_SettlementDetailInfoHeader: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var orderNoBgView: UIView!
    @IBOutlet weak var lab_orderNo: UILabel!
    
    @IBOutlet weak var lab_header: UILabel!
    
    @IBOutlet weak var titlebgView: UIView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
       
        let image = UIImage(named: "home_order_bg_top")
        self.bgView.layer.contents = image?.cgImage
        
        let image2 = UIImage(named: "header_title_bg")
        self.titlebgView.layer.contents = image2?.cgImage
    
        orderNoBgView.makeLayerRadius(value: 5,type: [.layerMinXMinYCorner,.layerMaxXMinYCorner])
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_SettlementDetailInfoHeader: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
      
    }
    
    func row_update(dataSource data: (String,String)) {
        lab_orderNo.text = "单号：".languageString()+data.0
        lab_header.text = data.1
    }
    
}
