//
//  Cell_SettlementDetailRemark.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/27.
//

import UIKit

class Cell_SettlementDetailRemark: UITableViewCell, UITextViewDelegate {
    @IBOutlet weak var bgViewTrailingC: NSLayoutConstraint!
    @IBOutlet weak var bgViewLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var cellTextView: UITextView!
    @IBOutlet weak var lineView: UIView!
    
    // 事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        cellTextView.delegate = self
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    func textViewDidChange(_ textView: UITextView) {
        callBack?((UIControl.Event.editingChanged,textView.text ?? ""))
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
//        callBack?((UIControl.Event.editingDidEnd,textView.text ?? ""))
        callBack?((textView.text ?? ""))
    }
    
}

extension Cell_SettlementDetailRemark:TCCell_RowCellUpdateProtocol {
    // value、placeholder 、输入正则
    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        self.backgroundColor = data.cellColor
        bgViewLeadingC.constant = data.bgViewLeading ?? 0
        bgViewTrailingC.constant = data.bgViewTrailing ?? 0
        
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
//            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            showStr.insert(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]), at: 0)
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
        
        cellTextView.isEditable = data.canEdit
    }
    
    func row_update(dataSource data: (String, String, String)) {
        cellTextView.text = data.0
        cellTextView.placeholder = data.1
    }
    
}

