//
//  Cell_SettlementInvoceCode.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/28.
//

import UIKit

class Cell_SettlementInvoceCode: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var btn_scan: UIButton!
    @IBOutlet weak var tf_code: UITextField!
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    
        tf_code.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        tf_code.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
        
        tf_code.placeholder = "请输入".languageString()
    }

    @IBAction func scanAction(_ sender: UIButton) {
        callBack?("扫码")
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
}


extension Cell_SettlementInvoceCode: TCCell_RowCellUpdateProtocol {
    // title宽度、value、placeholder  正则、键盘类型
    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        tf_code.isEnabled = data.canEdit
    }
    
    func row_update(dataSource data: (String,String)) {
        tf_code.text = data.0
        lab_title.text = data.1
    }
    
}
