//
//  Cell_SettlementCheckImage.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/10.
//

import UIKit

class Cell_SettlementCheckImage: UITableViewCell {
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var bgView1: UIView!
    @IBOutlet weak var img_1: UIImageView!

    @IBOutlet weak var bgView2: UIView!
    @IBOutlet weak var img_2: UIImageView!

    @IBOutlet weak var bgView3: UIView!
    @IBOutlet weak var img_3: UIImageView!
    
    var callBack: TCRowCallBack?
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
        let tap1 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_1.addGestureRecognizer(tap1)
        img_1.isUserInteractionEnabled = true
        
        let tap2 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_2.addGestureRecognizer(tap2)
        img_2.isUserInteractionEnabled = true
        
        let tap3 = UITapGestureRecognizer(target: self, action: #selector(imageChange(_:)))
        img_3.addGestureRecognizer(tap3)
        img_3.isUserInteractionEnabled = true
    }
    
    
    @objc func imageChange(_ sender:UITapGestureRecognizer){
        if sender.view == img_1{
            callBack?(1)
        } else if sender.view == img_2{
            callBack?(2)
        } else if sender.view == img_3{
            callBack?(3)
        }
       
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension Cell_SettlementCheckImage: TCCell_RowCellUpdateProtocol {

    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        lab_title.text = data.titleText
    }
    
    func row_update(dataSource data: (String,String,String)) {
        if data.0 != ""{
            img_1.sd_setImage(with: URL(string: data.0))
            img_1.isUserInteractionEnabled = true
        }else{
            img_1.sd_setImage(with: URL(string: ""))
            img_1.isUserInteractionEnabled = false
        }
        
        if data.1 != ""{
            bgView2.isHidden = false
            img_2.isHidden = false
            img_2.sd_setImage(with: URL(string: data.1))
            img_2.isUserInteractionEnabled = true
    
        }else{
            bgView2.isHidden = true
            img_2.isHidden = true
            img_2.sd_setImage(with: URL(string: ""))
            img_2.isUserInteractionEnabled = false
        }
        
        if data.2 != ""{
            bgView3.isHidden = false
            img_3.isHidden = false
            img_3.sd_setImage(with: URL(string: data.2))
            img_3.isUserInteractionEnabled = true

        }else{
            bgView3.isHidden = true
            img_3.isHidden = true
            img_3.sd_setImage(with: URL(string: ""))
            img_3.isUserInteractionEnabled = false
        }
        
        img_1.layer.cornerRadius = 8
        img_1.layer.masksToBounds = true
        img_2.layer.cornerRadius = 8
        img_2.layer.masksToBounds = true
        img_3.layer.cornerRadius = 8
        img_3.layer.masksToBounds = true

    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
}

