//
//  SettlementAmountGetVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/20.
//

import UIKit

public struct R_SettlementAmountGet {
    static func router(_ callback: ((Bool)->Void)?) {
        let vc = SettlementAmountGetVc.cd_storyboard("Settlement", from: "SettlementAmountGetVc") as! SettlementAmountGetVc
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementAmountGetVc: UIViewController,CLLocationManagerDelegate {
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var submitBtn: UIButton!
  
    var vm = SettlementAmountGetVm()

    var callback: ((Bool)->Void)?
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "发起结算申请".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        self.configTableView()
        self.requestData()
        
        self.submitBtn.setTitle("提交结算申请".languageString(), for: .normal)
       
    }
    
    func configTableView() {
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
        vm.callback = {
            self.tableView.reloadData()
        }

        vm.makeForms()
    }

    @IBAction func submitAction(_ sender: UIButton) {
        guard self.vm.timeId != "" else {
            hud_info("请选择结算周期~".languageString())
            return
        }
        requestSubmit()
    }
    
}



//网络请求
extension SettlementAmountGetVc{
   
    func requestData(){
        var param = [String:Any]()

        let cNet = TWOCNetwork(url: "/app/v2/settle/settlePage",andParam: param)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            if let data = result["data"] as? [String:Any] {
                weakSelf.vm.dataDict = data
                weakSelf.vm.makeForms()
            }
        }
        cNet.failCall = {(errorTag,errorStr) in
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
    func requestSubmit(){
        var param = [String:Any]()
        param["timeId"] = vm.timeId
        SVProgressHUD.show()
        let cNet = TWOCNetwork(url: "/app/v2/settle/createSettle",andParam: param)
        cNet.successCall = { [weak self] (result) in
            SVProgressHUD.dismiss()
            guard let weakSelf = self else { return }
            //跳转结算列表
            DispatchQueue.main.async(execute: {
                hud_info("操作成功~".languageString())
                self?.navigationController?.popViewController(animated: true)
                self?.callback?(true)
            })
        }
        cNet.failCall = {(errorTag,errorStr) in
            SVProgressHUD.dismiss()
            DispatchQueue.main.async(execute: {
                hud_error(errorStr)
            })
            
        }
        cNet.postRequest()
    }
}


// MARK: - Table view data source
extension SettlementAmountGetVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}


