//
//  SettlementApplyMainVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/22.
//

import UIKit
import JXSegmentedView

public struct R_SettlementApplyMain {
    static func router(_ param:[String:Any],callback: ((String)->Void)?) {
        let vc = SettlementApplyMainVc.cd_storyboard("Settlement", from: "SettlementApplyMainVc") as! SettlementApplyMainVc
        let index = param.intForKey("index")

        vc.currentIndex = index
        vc.timeId = param.stringValue(forKey: "timeId")
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementApplyMainVc: UIViewController {
    @IBOutlet weak var headView: UIView!
    @IBOutlet weak var titleView: UIView!
    @IBOutlet weak var childView: UIView!
    @IBOutlet weak var tf_search: UITextField!
    var searchKey = ""
    var searchType = ""
    var currentIndex = 0
    var timeId = ""
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles = ["全部".languageString(),"待确认".languageString(),"待开票".languageString(), "已结算".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = UIColor(hexString: "808383")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = UIColor(hexString: "#333333")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = UIColor(hexString: "#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var curVC:SettlementApplyListVc?
    var callback:((String)->())?
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "结算申请单".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = .groupTableViewBackground
        self.cd.navigationBar(hidden: false)
       
        configUI()
    }
    
    func configUI() {
        tf_search.placeholder = "请输入结算单号/工单号".languageString()
        segmentedView.defaultSelectedIndex = currentIndex
        segmentedDataSource.reloadData(selectedIndex: currentIndex)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        
        titleView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(48)
        }
        
        segmentedView.listContainer = listContainerView
        childView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
        
        addSubViewControlls()
        setOrderLineCurrentVC(currentIndex)
        setCurrentVC()
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchKey = sender.txt
        curVC?.searchKey = searchKey
        curVC?.tableView.mj_header.beginRefreshing()
    }
    
    func updateSegmentedDataSourceTitles(_ data:[String:Any]) {
        self.segmentedtTitles[0] = "全部".languageString()+" "+data.stringValue(forKey: "allQty")
        self.segmentedtTitles[1] = "待确认".languageString()+" "+data.stringValue(forKey: "waitCheckSettleQty")
        self.segmentedtTitles[2] = "待开票".languageString()+" "+data.stringValue(forKey: "unMakeInvoiceQty")
        self.segmentedtTitles[3] = "已结算".languageString()+" "+data.stringValue(forKey: "settleQty")
        
        self.segmentedDataSource.titles = self.segmentedtTitles
        self.segmentedView.reloadData()
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC = SettlementApplyListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 0
            curViewC.callback = { (data) in
                self.updateSegmentedDataSourceTitles(data)
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementApplyListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 1
            curViewC.callback = { (data) in
                self.updateSegmentedDataSourceTitles(data)
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementApplyListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 2
            curViewC.callback = { (data) in
                self.updateSegmentedDataSourceTitles(data)
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementApplyListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 3
            curViewC.callback = { (data) in
                self.updateSegmentedDataSourceTitles(data)
            }
            cSubC.append(curViewC)
        }
        
        subControllerList = cSubC
    }
    
    func setCurrentVC() {
        let vc = subControllerList[segmentedView.selectedIndex] as! SettlementApplyListVc
        curVC = vc
    }
    
    func setOrderLineCurrentVC(_ index:Int){
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: index)
        }else{
            segmentedDataSource.reloadData(selectedIndex: index)
        }
    }
    

}



extension SettlementApplyMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        let vc = subControllerList[index] as! SettlementApplyListVc
        curVC = vc
        
        if vc.isViewLoaded{
            curVC?.searchKey = searchKey
            curVC?.tableView.mj_header.beginRefreshing()
        }
    }
}
