//
//  SettlementCheckOrderMainVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/7.
//  考核单

import UIKit
import JXSegmentedView

public struct R_SettlementCheckOrderMain {
    static func router(_ param:[String:Any],callback: ((String)->Void)?) {
        let vc = SettlementCheckOrderMainVc.cd_storyboard("Settlement", from: "SettlementCheckOrderMainVc") as! SettlementCheckOrderMainVc
        let index = param.intForKey("index")
    
        vc.currentIndex = index
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementCheckOrderMainVc: UIViewController {
    @IBOutlet weak var headView: UIView!
    @IBOutlet weak var titleView: UIView!
    @IBOutlet weak var childView: UIView!
    @IBOutlet weak var tf_search: UITextField!
    var searchKey = ""
    var searchType = ""
    var currentIndex = 0
   
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles = ["全部".languageString(),"待申诉".languageString(),"申诉待审核".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = UIColor(hexString: "808383")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = UIColor(hexString: "#333333")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = UIColor(hexString: "#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var curVC:SettlementCheckOrderListVc?
    var callback:((String)->())?
   
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "考核单".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        self.cd.navigationBar(hidden: false)
       
        configUI()
    }
    
    func configUI() {
        tf_search.placeholder = "请输入结算单号/工单号".languageString()
        segmentedView.defaultSelectedIndex = currentIndex
        segmentedDataSource.reloadData(selectedIndex: currentIndex)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        
        titleView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(48)
        }
        
        segmentedView.listContainer = listContainerView
        childView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
        
        addSubViewControlls()
        setOrderLineCurrentVC(currentIndex)
        setCurrentVC()
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchKey = sender.txt
        curVC?.searchKey = searchKey
        curVC?.tableView.mj_header.beginRefreshing()
    }
    
    func updateSegmentedDataSourceTitles(_ dataDic:[String:Any]) {
        self.segmentedtTitles[0] = "全部".languageString()+" "+dataDic.stringValue(forKey: "allQty")
        self.segmentedtTitles[1] = "待申诉".languageString()+" "+dataDic.stringValue(forKey: "unComplainCheckBillQty")
        self.segmentedtTitles[2] = "申诉待审核".languageString()+" "+dataDic.stringValue(forKey: "unCheckBillQty")
        self.segmentedtTitles[2] = "申诉待审核".languageString()+" "+dataDic.stringValue(forKey: "unCheckBillQty")
        
        self.segmentedDataSource.titles = self.segmentedtTitles
        self.segmentedView.reloadData()
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC = SettlementCheckOrderListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 0
            curViewC.requestUrl = "app/v2/checkBill/checkBillSearch"
          
            curViewC.callback = { (dataDic) in
                self.updateSegmentedDataSourceTitles(dataDic)
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementCheckOrderListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 1
            curViewC.requestUrl = "app/v2/checkBill/checkBillSearch"
          
            curViewC.callback = { (dataDic) in
                self.updateSegmentedDataSourceTitles(dataDic)
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementCheckOrderListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 2
            curViewC.requestUrl = "app/v2/checkBill/checkBillSearch"
          
            curViewC.callback = { (dataDic) in
                self.updateSegmentedDataSourceTitles(dataDic)
            }
            cSubC.append(curViewC)
        }

        subControllerList = cSubC
    }
    
    func setCurrentVC() {
        let vc = subControllerList[segmentedView.selectedIndex] as! SettlementCheckOrderListVc
        curVC = vc
    }
    
    func setOrderLineCurrentVC(_ index:Int){
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: index)
        }else{
            segmentedDataSource.reloadData(selectedIndex: index)
        }
    }
    

}



extension SettlementCheckOrderMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        let vc = subControllerList[index] as! SettlementCheckOrderListVc
        curVC = vc
        
        if vc.isViewLoaded{
            curVC?.searchKey = searchKey
            curVC?.tableView.mj_header.beginRefreshing()
        }
    }
}


