//
//  SettlementCheckSureVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/10.
//  申诉审核

import UIKit

public struct R_SettlementCheckSure {
    static func router(_ param:[String:Any],callback: ((Bool)->Void)?) {
        let vc = SettlementCheckSureVc.cd_storyboard("Settlement", from: "SettlementCheckSureVc") as! SettlementCheckSureVc
        vc.checkBillId = param.stringValue(forKey: "checkBillId")
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementCheckSureVc: UIViewController {
   
    @IBOutlet weak var tableView: UITableView!
    
    @IBOutlet weak var btn_submit: UIButton!
    var requestUrl = "app/v2/checkBillDo/auditCheckBill"
    var vm = SettlementCheckSureVm()
    var checkBillId = ""
    var callback: ((Bool)->Void)?
    var picTag = 1
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "申诉审核".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        self.cd.navigationBar(hidden: false)
        btn_submit.setTitle("提交".languageString(), for: .normal)
        configTableView()
    }
    
    func configTableView() {
        view.addSubview(tableView)
        
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
       
        vm.callback = {
            self.tableView.reloadData()
        }
        
        vm.makeForms()
    }

    @IBAction func submitAction(_ sender: UIButton) {
        guard vm.result != "" else {
            hud_error("请选择".languageString()+"审批结果".languageString())
            return
        }
        guard vm.checkAmount != "" else {
            hud_error("请输入".languageString()+"审批金额".languageString())
            return
        }
        
        guard vm.remark != "" else {
            hud_error("请输入".languageString()+"审批内容".languageString())
            return
        }
        
        self.requstData()
    }
    
    
}


//网络请求
extension SettlementCheckSureVc{
    
    func requstData(){
        var param = [String:Any]()
        param["settleId"] = checkBillId
        
        param["checkNote"] = vm.remark
        param["checkResult"] = vm.result
        param["checkAmount"] = vm.checkAmount
        
        let cNet = TWOCNetwork(url: requestUrl,andParam: param)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            DispatchQueue.main.async(execute: {
                hud_info("操作成功~".languageString())
                self?.navigationController?.popViewController(animated: true)
                self?.callback?(true)
            })
        }
        cNet.failCall = { [weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
    
}

// MARK: - Table view data source
extension SettlementCheckSureVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}

