//
//  SettlementDetailAdjustListVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/26.
//

import UIKit
import MJRefresh

public struct R_SettlementDetailAdjustList {
    static func router(_ param:[String:Any],callback: ((String)->Void)?) {
        let vc = SettlementDetailAdjustListVc.cd_storyboard("Settlement", from: "SettlementDetailAdjustListVc") as! SettlementDetailAdjustListVc
        vc.settleId = param.stringValue(forKey: "settleId")
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementDetailAdjustListVc: UIViewController {
    @IBOutlet weak var headView: UIView!
    @IBOutlet weak var childView: UIView!
    @IBOutlet weak var tf_search: UITextField!
    
    lazy var tableView: UITableView = {
        let tab = UITableView()
        return tab
    }()
   
    var searchKey = ""
    var searchType = 0
    var pagenumber = 1
    var pageSize = 10
    var totalpages = 1
    var requestUrl = "app/v2/settle/getAdjustListBySettleId"
    var vm = SettlementDetailAdjustListVm()
    var settleId = ""
    var callback:((String)->())?
 
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "调整单明细".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        self.cd.navigationBar(hidden: false)
       
        configUI()
        
        requstData()
    }
    
    func configUI() {
        configTableView()
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchKey = sender.txt
        self.tableView.mj_header.beginRefreshing()
    }
    
    func configTableView() {
        childView.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
        
        self.tableView.backgroundColor = UIColor(hexString: "f8f8f8")
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        }
        tableView.delegate = self
        tableView.dataSource = self
        tableView.separatorStyle = .none
       
        
        let header = MJRefreshNormalHeader()
        header.stateLabel.textColor = UIColor(hexString: "999999")
        let footer = MJRefreshAutoNormalFooter()
        footer.stateLabel.textColor = UIColor(hexString: "999999")
        footer.isOnlyRefreshPerDrag = true
        
        header.setRefreshingTarget(self, refreshingAction: #selector(headerRefresh))
        footer.setRefreshingTarget(self, refreshingAction: #selector(footerRefresh))
        tableView.mj_header = header
        tableView.mj_footer = footer
        
        vm.callback = {
            self.tableView.reloadData()
            self.showNoMoreData(self.vm.dataArray)
        }
        
        vm.makeForms()
    }
    
    func showNoMoreData(_ datas:[[String:Any]]){
        if pageSize > datas.count{
            self.tableView.mj_footer.endRefreshingWithNoMoreData()
        }else{
            self.tableView.mj_footer.resetNoMoreData()
        }
    }

}


//网络请求
extension SettlementDetailAdjustListVc{
    //mark refresh
    @objc func headerRefresh(){
        self.tableView.mj_header.endRefreshing()
        pagenumber = 1
        requstData()
    }
    
    @objc func footerRefresh(){
        self.tableView.mj_footer.endRefreshing()
        pagenumber = pagenumber + 1
        requstData()
        
//        if pagenumber < totalpages{
//            pagenumber = pagenumber + 1
//            requstData()
//        }else{
//            self.tableView.mj_footer.endRefreshing()
//            self.tableView.mj_footer.endRefreshingWithNoMoreData()
//        }
    }
    
    
    func requstData(){
        var param = [String:Any]()
        param["pageNumber"] = pagenumber
        param["pageSize"] = pageSize
        
        param["searchType"] = searchType
        param["searchKey"] = searchKey
        param["settleId"] = settleId
        
       
        let cNet = TWOCNetwork(url: requestUrl,andParam: param)
        cNet.successCall = { [weak self] (result) in
            guard let weakSelf = self else { return }
            weakSelf.tableView.mj_header.endRefreshing()
            if let data = result["data"] as? [String:Any] {
                if let dataList = data["orderList"] as? [[String:Any]]{
                    if weakSelf.pagenumber == 1{
                        weakSelf.vm.dataArray = dataList
                    }else{
                        weakSelf.vm.dataArray.append(contentsOf: dataList)
                    }
        
                    //刷新
                    weakSelf.vm.makeForms()
                }
                
            }else{
                hud_error("请求出错了，请稍后再试~".languageString())
            }
        }
        cNet.failCall = { [weak self](errorTag,errorStr) in
            guard let weakSelf = self else { return }
            weakSelf.tableView.mj_header.endRefreshing()
            hud_error(errorStr)
        }
        cNet.postRequest()
    }
    
}

// MARK: - Table view data source
extension SettlementDetailAdjustListVc: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return vm.forms.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cellVM = vm.forms[indexPath.row]
        let cellIdentifier = cellVM.cellId.isEmpty ? String(describing: cellVM.cellClass) : cellVM.cellId
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        if cell == nil {
            let bundle = Bundle.main.path(forResource:cellIdentifier, ofType: "nib")
            if bundle == nil{
                tableView.register(cellVM.cellClass, forCellReuseIdentifier: cellIdentifier)
            }else{
                let cellNib = UINib(nibName:cellIdentifier, bundle: nil)
                tableView.register(cellNib, forCellReuseIdentifier: cellIdentifier)
            }
            cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        }
        
        guard let endCell = cell else {
            fatalError("没有找到标识为：\(cellIdentifier)的Cell")
        }
        cellVM.bind(endCell)
        return endCell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView()
        view.backgroundColor = UIColor.init(hexString: "f8f8f8")
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, estimatedHeightForRowAt indexPath: IndexPath) -> CGFloat {
        return 44
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        let cellVM = vm.forms[indexPath.row]
        return cellVM.frameH
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let cellVM = vm.forms[indexPath.row]
        cellVM.tapBlock?()
    }
}
