//
//  SettlementDetailOrderListMainVc.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/26.
//

import UIKit
import JXSegmentedView

public struct R_SettlementDetailOrderListMain {
    static func router(_ param:[String:Any],callback: ((String)->Void)?) {
        let vc = SettlementDetailOrderListMainVc.cd_storyboard("Settlement", from: "SettlementDetailOrderListMainVc") as! SettlementDetailOrderListMainVc
        let index = param.intForKey("index")
        if index == 1{
            vc.vcType = .考核工单
        }
        vc.currentIndex = index
        vc.settleId = param.stringValue(forKey: "settleId")
        vc.callback = callback
        CD.push(vc)
    }
}

class SettlementDetailOrderListMainVc: UIViewController {
    @IBOutlet weak var headView: UIView!
    @IBOutlet weak var titleView: UIView!
    @IBOutlet weak var childView: UIView!
    @IBOutlet weak var tf_search: UITextField!
    var searchKey = ""
    var searchType = ""
    var currentIndex = 0
    var settleId = ""
    lazy var segmentedView: JXSegmentedView = {
        let segmentedV = JXSegmentedView()
        segmentedV.delegate = self
        return segmentedV
    }()
    
    var segmentedtTitles = ["工单".languageString(),"考核单".languageString()]
    
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let segmentedDa = JXSegmentedTitleDataSource()
        segmentedDa.titles = segmentedtTitles
        segmentedDa.isTitleColorGradientEnabled = true
        segmentedDa.titleNormalColor = UIColor(hexString: "808383")
        segmentedDa.titleNormalFont = UIFont.PingFangRegular(size: 14)
        segmentedDa.titleSelectedColor = UIColor(hexString: "#333333")
        segmentedDa.titleSelectedFont = UIFont.PingFangMedium(size: 14)
        return segmentedDa
    }()
    
    lazy var indicator:JXSegmentedIndicatorLineView = {
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorColor = UIColor(hexString: "#478BFF")
        indicator.indicatorWidth = 24
        return indicator
    }()
    
    lazy var listContainerView = JXSegmentedListContainerView(dataSource: self)
    lazy var subControllerList = [JXSegmentedListContainerViewListDelegate]()
    
    var curVC:SettlementDetailOrderListVc?
    var callback:((String)->())?
    var vcType:OrderLineType = .普通工单
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
       
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "业务明细".languageString()
        self.setNavigationBackButton()
        self.view.backgroundColor = UIColor(hexString: "f8f8f8")
        self.cd.navigationBar(hidden: false)
       
        configUI()
    }
    
    func configUI() {
        tf_search.placeholder = "请输入结算单号/工单号".languageString()
        segmentedView.defaultSelectedIndex = currentIndex
        segmentedDataSource.reloadData(selectedIndex: currentIndex)
        segmentedView.indicators = [indicator]
        segmentedView.dataSource = segmentedDataSource
        
        titleView.addSubview(segmentedView)
        segmentedView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(48)
        }
        
        segmentedView.listContainer = listContainerView
        childView.addSubview(listContainerView)
        listContainerView.snp.makeConstraints { make in
            make.top.bottom.left.right.equalToSuperview()
         }
        
        addSubViewControlls()
        setOrderLineCurrentVC(currentIndex)
        setCurrentVC()
    }
    
    @IBAction func editingDidEnd(_ sender: UITextField) {
        searchKey = sender.txt
        curVC?.searchKey = searchKey
        curVC?.tableView.mj_header.beginRefreshing()
    }
    
    func addSubViewControlls() {
        var cSubC = [JXSegmentedListContainerViewListDelegate]()
        
        do {
            let curViewC = SettlementDetailOrderListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 0
            curViewC.requestUrl = "app/v2/settle/getOrderListBySettleId"
            curViewC.vm.vcType = .普通工单
            curViewC.numCallback = { (num) in
                self.segmentedtTitles[0] = "工单".languageString()+" "+num
                self.segmentedDataSource.titles = self.segmentedtTitles
                self.segmentedView.reloadData()
            }
            curViewC.callback = { (arr) in
                if self.vcType == .普通工单{
                    let amount = arr.map{(Float($0.stringValue("siteFinalAmount")) ?? 0.00 * 1)}.reduce(0, +)
                    self.callback?(String(amount))
                }
            }
            cSubC.append(curViewC)
        }
        
        do {
            let curViewC = SettlementDetailOrderListVc()
            curViewC.searchKey = searchKey
            curViewC.searchType = 1
            curViewC.requestUrl = "app/v2/settle/getCheckListBySettleId"
          
            curViewC.vm.vcType = .考核工单
            curViewC.numCallback = { (num) in
                self.segmentedtTitles[1] = "考核单".languageString()+" "+num
                self.segmentedDataSource.titles = self.segmentedtTitles
                self.segmentedView.reloadData()
            }
            curViewC.callback = { (arr) in
                if self.vcType == .考核工单{
                    let amount = arr.map{(Float($0.stringValue("checkAmount")) ?? 0.00 * 1)}.reduce(0, +)
                    self.callback?(String(amount))
                }
            }
            cSubC.append(curViewC)
        }

        subControllerList = cSubC
    }
    
    func setCurrentVC() {
        let vc = subControllerList[segmentedView.selectedIndex] as! SettlementDetailOrderListVc
        curVC = vc
    }
    
    func setOrderLineCurrentVC(_ index:Int){
        if !subControllerList.isEmpty {
            segmentedView.selectItemAt(index: index)
        }else{
            segmentedDataSource.reloadData(selectedIndex: index)
        }
    }
    

}



extension SettlementDetailOrderListMainVc: JXSegmentedViewDelegate, JXSegmentedListContainerViewDataSource {
    
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        return subControllerList.count
    }
    
    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return subControllerList[index]
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        let vc = subControllerList[index] as! SettlementDetailOrderListVc
        curVC = vc
        
        if vc.isViewLoaded{
            curVC?.searchKey = searchKey
            curVC?.tableView.mj_header.beginRefreshing()
        }
    }
}

