//
//  SettlementAmountGetVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/20.
//

import UIKit

class SettlementAmountGetVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataDict = [String:Any]()
    
    var timeId = ""
    var timeName = ""
    
    var amount1 = "0"
    var amount2 = "0"
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("结算周期".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showLine(true)
                .textAlignment(.right)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, timeName, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                if let theTimeArr = self?.dataDict["settleTimeList"] as? [[String:Any]]{
                    self?.showTimesPicker(comArr: theTimeArr)
                }
                
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("税率".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(false)
                .showLine(true)
                .textAlignment(.right)
            var value = dataDict.stringValue(forKey: "taxRate")
            if value == "" {
                value = "0"
            }
            
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, value+"%", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("工单合计".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showLine(true)
                .textAlignment(.right)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, "¥"+self.amount1, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                var param = [String:Any]()
                param["timeId"] = self?.timeId
                param["index"] = 0
                R_SettlementOrderLine.router(param) { amount in
                    self?.amount1 = amount
                    self?.makeForms()
                }
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("考核合计".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "666666"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(true)
                .showLine(true)
                .textAlignment(.right)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, "¥"+self.amount2, ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                var param = [String:Any]()
                param["timeId"] = self?.timeId
                param["index"] = 1
                R_SettlementOrderLine.router(param) { amount in
                    self?.amount2 = amount
                    self?.makeForms()
                }
            })
            newForms.append(rowCell)
        }
       

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        //提示文本
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "f8f8f8"))
                .title("结算政策：".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "#478BFF"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: 40, didSelect:  { [weak self] in
            })
            newForms.append(rowCell)
        }
        
        do {
            var value = dataDict.stringValue(forKey: "settlePolicy")
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(0).setBgViewTrailing(0).setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "f8f8f8"))
                .title(value)
                .titleFont(UIFont.systemFont(ofSize: 13))
                .titleColor(UIColor(hexString: "#999999"))
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
            newForms.append(rowCell)
        }
        
       return newForms
    }
    
    
    
    func showTimesPicker(comArr:[[String:Any]])  {
        let pickerDataArr = comArr.compactMap {
            ($0.stringValue(forKey: "timeName"),"")
        }
        TWSheetPicker.showActionSheet(titleStr: "请选择结算周期".languageString(), singleType: true, dataArr: pickerDataArr) {  [weak self] (indexArr) in
            guard let weakSelf = self else { return }
            guard let index = indexArr.first else { return }
            let curComp = comArr[index]
            weakSelf.timeId = curComp.stringValue(forKey: "timeId")
            weakSelf.timeName = curComp.stringValue(forKey: "timeName")
            weakSelf.makeForms()
        }.show(CD.visibleVC!)
    }
}
