//
//  SettlementCheckAppealVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/10.
//

import UIKit

class SettlementCheckAppealVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var imageCallback:((Int)->())?
    var remark = ""
    
    var pic1 = ""
    var pic2 = ""
    var pic3 = ""
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
      
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("申诉内容".languageString())
                    .titleColor(UIColor(hexString: "666666"))
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .canEdit(true)
                    .showTip(true)
                    .showLine(true)
                let rowCell = TCFormCellModel<Cell_SettlementDetailRemark>.init(data: (remark, "请填写".languageString(), ""), config: uiConfigModel, id: nil, frameh: 120) { [weak self] callValue in
                    
                    if let value = callValue as? (UIControl.Event,String) {
                        self?.remark = value.1
                    }
                    
                    if let value = callValue as? String {
                        self?.remark = value
                        self?.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
        
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.title("申诉凭证".languageString())
            let rowCell = TCFormCellModel<Cell_SettlementDetailImage>.init(data: (kGetServerPicUrl(pic1) ,kGetServerPicUrl(pic2),kGetServerPicUrl(pic3)), config: uiConfigModel, id: nil, frameh: 144) {[weak self] (a) in
                guard let weakSelf = self else { return }
        
                if let theTag = a as? Int {
                    self?.imageCallback?(theTag)
                }
                
                if let theTag = a as? String {
                    if theTag == "delete1"{
                        self?.pic1 = ""
                    }
                   else if theTag == "delete2"{
                       self?.pic2 = ""
                    }
                    else if theTag == "delete3"{
                        self?.pic3 = ""
                    }
                    
                    self?.makeForms()
                }
               
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
}

