//
//  SettlementCheckOrderDetailVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/8.
//

import UIKit

class SettlementCheckOrderDetailVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataDict = [String:Any]()
   
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
        newForms += makeAppealInfoForms()
        newForms += makeApprovalInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
       
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_SettlementDetailHeader>.init(data: (dataDict), config: uiConfigModel, id: nil, frameh: 100, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
               
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let no = dataDict.stringValue(forKey: "checkBillNo")
            let rowCell = TCFormCellModel<Cell_SettlementDetailInfoHeader>.init(data: (no,"考核信息".languageString()), config: uiConfigModel, id: nil, frameh: 100, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
               
            })
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("考核对象".languageString(), value: dataDict.stringValue(forKey: "checkSubjectName")))
        newForms.append(self.makeTextLineCell("产生时间".languageString(), value: dataDict.stringValue(forKey: "createTime")))
        newForms.append(self.makeTextLineCell("费用类型".languageString(), value: dataDict.stringValue(forKey: "feeAttributeName")))
        newForms.append(self.makeTextLineCell("考核金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "checkAmount")))
        
        newForms.append(self.makeTextLineCell("调整金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "adjustAmount")))
        newForms.append(self.makeTextLineCell("合计金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "amount")))
        newForms.append(self.makeTextLineCell("备     注".languageString(), value: dataDict.stringValue(forKey: "remark"),rowHeight: UITableView.automaticDimension))
        
        //凭证
        let pic1 = kGetServerPicUrl(dataDict.stringValue(forKey: "proofAttachment1"))
        let pic2 = kGetServerPicUrl(dataDict.stringValue(forKey: "proofAttachment2"))
        let pic3 = kGetServerPicUrl(dataDict.stringValue(forKey: "proofAttachment3"))
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.title("凭    证")
            let rowCell = TCFormCellModel<Cell_SettlementCheckImage>.init(data: (pic1,pic2,pic3), config: uiConfigModel, id: nil, frameh: 80) {[weak self] (a) in
                guard let weakSelf = self else { return }
        
                if let theTag = a as? Int {
                    //大图
                    switch theTag {
                    case 1:
                        self?.showBigImage(pic1)
                        break
                    case 2:
                        self?.showBigImage(pic2)
                        break
                    case 3:
                        self?.showBigImage(pic3)
                        break
                    default:
                        break
                    }
                }
            }
            newForms.append(rowCell)
        }
        
        //分割线
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(UIColor.white)
                .setCellColor(UIColor(hexString: "f8f8f8"))
                .setBgViewLeading(12)
                .setBgViewTrailing(12)
        
            let rowCell = TCFormCellModel<Cell_DottedLine>.init(data: (0.5,UIColor(hexString: "C7C7CC")), config: uiConfigModel, id: nil, frameh: 20)
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("关联工单".languageString(), value: dataDict.stringValue(forKey: "orderNo")))
        newForms.append(self.makeTextLineCell("服务人员".languageString(), value: dataDict.stringValue(forKey: "engineerName")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
       
       return newForms
    }
    
    func makeAppealInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("申诉详情".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("申诉时间".languageString(), value: dataDict.stringValue(forKey: "siteAnswerDate")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("申诉意见".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "#999999"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(false)
                .showLine(false)
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (88, dataDict.stringValue(forKey: "siteAnswerNote"), ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
            
            newForms.append(rowCell)
        }
        
        //审批凭证
        let pic1 = kGetServerPicUrl(dataDict.stringValue(forKey: "answerAttachment1"))
        let pic2 = kGetServerPicUrl(dataDict.stringValue(forKey: "answerAttachment2"))
        let pic3 = kGetServerPicUrl(dataDict.stringValue(forKey: "answerAttachment3"))
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.title("审批凭证".languageString())
            let rowCell = TCFormCellModel<Cell_SettlementCheckImage>.init(data: (pic1,pic2,pic3), config: uiConfigModel, id: nil, frameh: 80) {[weak self] (a) in
                guard let weakSelf = self else { return }
        
                if let theTag = a as? Int {
                    //大图
                    switch theTag {
                    case 1:
                        self?.showBigImage(pic1)
                        break
                    case 2:
                        self?.showBigImage(pic2)
                        break
                    case 3:
                        self?.showBigImage(pic3)
                        break
                    default:
                        break
                    }
                }
            }
            newForms.append(rowCell)
        }
     
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
    
    func makeApprovalInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("审批详情".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("审核人员".languageString(), value: dataDict.stringValue(forKey: "checkMan")))
        
        newForms.append(self.makeTextLineCell("审批时间".languageString(), value: dataDict.stringValue(forKey: "checkDate")))
        
        newForms.append(self.makeTextLineCell("审批结果".languageString(), value: dataDict.stringValue(forKey: "checkResult")))
        
        newForms.append(self.makeTextLineCell("审批金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "checkAmount")))
      
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .title("审批意见".languageString())
                .titleFont(UIFont.systemFont(ofSize: 14))
                .titleColor(UIColor(hexString: "#999999"))
                .infoFont(UIFont.systemFont(ofSize: 14))
                .infoColor(UIColor(hexString: "333333"))
                .showNext(false)
                .showLine(false)
                .textAlignment(.left)
            let rowCell = TCFormCellModel<TCLabelCell>.init(data: (88, dataDict.stringValue(forKey: "checkNote"), ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
            })
            
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
        
    
    func makeTextLineCell(_ title:String,value:String,rowHeight:CGFloat = 34)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.left)
        let rowCell = TCFormCellModel<TCLabelCell>.init(data: (88, value, ""), config: uiConfigModel, id: nil, frameh: rowHeight, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
    
    func showBigImage(_ url:String){
        var picList = [String]()
        picList.append(url)
        let photos = picList.compactMap({ (item) -> GKPhoto in
            let photo = GKPhoto()
            guard let imageUrl = URL(string: item) else {
                return photo
            }
            photo.url = imageUrl
            return photo
        })
        
        let index = 0
        
        let browser = GKPhotoBrowser(photos: photos, currentIndex: index)
        browser.showStyle = .none
        browser.modalPresentationStyle = .overFullScreen
        browser.show(fromVC: CD.visibleVC!)
    }
    
}
