//
//  SettlementCheckOrderListVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/7.
//

import UIKit

class SettlementCheckOrderListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataArray = [[String:Any]]()
   
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        guard self.dataArray.count != 0 else {
            return []
        }
        
        for item in dataArray {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                let rowCell = TCFormCellModel<Cell_SettlementCheckOrderListHeader>.init(data: (item), config: uiConfigModel, id: nil, frameh: 40, didSelect:  {  [weak self] in
                    //查看详情
                    guard let weakSelf = self else { return }
                   
                })
                newForms.append(rowCell)
            }
            let settleId = item.stringValue(forKey: "checkBillId")
            
            
            newForms.append(self.makeTextLineCell("考核对象".languageString(), value: item.stringValue(forKey: "siteName"), settleId: settleId))
            newForms.append(self.makeTextLineCell("产生时间".languageString(), value: item.stringValue(forKey: "createTime"), settleId: settleId))
            newForms.append(self.makeTextLineCell("考核科目".languageString(), value: item.stringValue(forKey: "checkSubjectName"), settleId: settleId))
            newForms.append(self.makeTextLineCell("合计金额".languageString(), value: "¥"+item.doubleForKey("checkAmount").stringValue, settleId: settleId))
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
        }
        
       
       return newForms
    }
    
    
    func makeTextLineCell(_ title:String,value:String,settleId:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.left)
        let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, value, ""), config: uiConfigModel, id: nil, frameh: 34, didSelect:  { [weak self] in
            
            R_SettlementCheckOrderDetail.router(["settleId":settleId]) { bool in
                
            }
        })
        
        return rowCell
    }
    
}
