//
//  SettlementCheckSureVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/10/10.
//

import UIKit

class SettlementCheckSureVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?

    var remark = ""
    var result = ""
    var checkAmount = ""
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do { // result,审核结果:1申诉成立;2申诉不成立;
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .showLine(true)
                .showTip(true)
                .title("审批结果".languageString())
                .titleColor(UIColor(hexString: "666666"))
                .setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(.white)
                .canEdit(true)
                .showLine(true)
                .setBgViewLeading(12)
                .setBgViewTrailing(12)
            let rowCell = TCFormCellModel<TCSwitchCell>.init(data: ("申诉成立".languageString(), 92, 1001, "申诉不成立".languageString(), 92, 1002, self.result.intValue()+1000), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension) { [weak self] callValue in
                guard let weakSelf = self else { return }
                if let value = callValue as? Int {
                    weakSelf.result = "\(value - 1000)"
                    weakSelf.makeForms()
                }
            }
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "审批金额".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "ffffff"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.right)
                .showLine(true)
                .showTip(true)
                .canEdit(true)
            
            let placeholderText = "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, checkAmount, placeholderText, nil, .decimalPad), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                guard let weakSelf = self else { return }
            
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.checkAmount = cValue.1
                       
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
      
        
        
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title("审批内容".languageString())
                    .titleColor(UIColor(hexString: "666666"))
                    .titleFont(UIFont.systemFont(ofSize: 14))
                    .canEdit(true)
                    .showTip(false)
                    .showLine(true)
                let rowCell = TCFormCellModel<Cell_SettlementDetailRemark>.init(data: (remark, "请输入".languageString(), ""), config: uiConfigModel, id: nil, frameh: 120) { [weak self] callValue in
                    
                    if let value = callValue as? (UIControl.Event,String) {
                        self?.remark = value.1
                    }
                    
                    if let value = callValue as? String {
                        self?.remark = value
                        self?.makeForms()
                    }
                }
                newForms.append(rowCell)
            }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
}
