//
//  SettlementDetailAdjustListVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/26.
//

import UIKit

class SettlementDetailAdjustListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataArray = [[String:Any]]()
  
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        guard self.dataArray.count != 0 else {
            return []
        }
        
        for (index,item) in dataArray.enumerated() {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                var title = ""
                title = "单号: ".languageString()+item.stringValue(forKey: "adjustNo")
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(title)
                    .titleFont(UIFont.boldSystemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "333333"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(false)
                    .showLine(true)
                    .textAlignment(.right)
               
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                })
                newForms.append(rowCell)
            }
            
            newForms.append(self.makeTextLineCell("费用名称".languageString(), value: item.stringValue(forKey: "serviceTypeName")))
            newForms.append(self.makeTextLineCell("金     额".languageString(), value: item.stringValue(forKey: "adjustAmount")))
            newForms.append(self.makeTextLineCell("备     注".languageString(), value: "¥"+item.stringValue(forKey: "adjustReason")))
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            if index == dataArray.count-1{
                do {
                    let uiConfigModel = TCFormCellConfigModel.defaultModel()
                        .bgColor(.clear)
                        .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                        .cornerRadius(8)
                    let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                    newForms.append(rowCell)
                }
            }
            
        }
        
       
       return newForms
    }
    
    
    func makeTextLineCell(_ title:String,value:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.left)
        let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, value, ""), config: uiConfigModel, id: nil, frameh: 34, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
}
