//
//  SettlementDetailVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/25.
//

import UIKit

class SettlementDetailVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataDict = [String:Any]()
   
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
        newForms += makeAmountInfoForms()
        newForms += makePayInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
       
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_SettlementDetailHeader>.init(data: (dataDict), config: uiConfigModel, id: nil, frameh: 100, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
               
            })
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let no = dataDict.stringValue(forKey: "settleNo")
            let rowCell = TCFormCellModel<Cell_SettlementDetailInfoHeader>.init(data: (no,"结算信息".languageString()), config: uiConfigModel, id: nil, frameh: 100, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
               
            })
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("结算对象".languageString(), value: dataDict.stringValue(forKey: "siteName")))
        newForms.append(self.makeTextLineCell("创建时间".languageString(), value: dataDict.stringValue(forKey: "createTime")))
        newForms.append(self.makeTextLineCell("结算项目".languageString(), value: "¥"+dataDict.stringValue(forKey: "settleTypeNames")))
        newForms.append(self.makeTextLineCell("总 金 额".languageString(), value: "¥"+dataDict.stringValue(forKey: "amount")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(UIColor.white)
                .setCellColor(UIColor(hexString: "f8f8f8"))
                .setBgViewLeading(12)
                .setBgViewTrailing(12)
        
            let rowCell = TCFormCellModel<Cell_DottedLine>.init(data: (0.5,UIColor(hexString: "C7C7CC")), config: uiConfigModel, id: nil, frameh: 20)
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("税    率".languageString(), value: dataDict.stringValue(forKey: "taxRate")))
        newForms.append(self.makeTextLineCell("税    额".languageString(), value: dataDict.stringValue(forKey: "taxAmount")))
        newForms.append(self.makeTextLineCell("发 票 号".languageString(), value: dataDict.stringValue(forKey: "invoiceNo")))
        newForms.append(self.makeTextLineCell("发票金额".languageString(), value: dataDict.stringValue(forKey: "invoiceNoAmount")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
       
       return newForms
    }
    
    func makeAmountInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("金额详情".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_SettlementDetailAmount>.init(data: ("业务单据总金额：".languageString(),dataDict.stringValue(forKey: "siteFinalAmount")), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
                R_SettlementDetailOrderListMain.router(["settleId":weakSelf.dataDict.stringValue(forKey: "settleId"),"index":0]) { a in
                    
                }
               
            })
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("工单数量".languageString(), value: dataDict.stringValue(forKey: "orderQty")))
        
        newForms.append(self.makeTextLineCell("机器数量".languageString(), value: dataDict.stringValue(forKey: "machineQty")))
        
        newForms.append(self.makeTextLineCell("服务费用".languageString(), value: "¥"+dataDict.stringValue(forKey: "siteAmount")))
        
        newForms.append(self.makeTextLineCell("奖罚金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "rewardAmount")))
        
        newForms.append(self.makeTextLineCell("远程费用".languageString(), value: "¥"+dataDict.stringValue(forKey: "longDistanceAmount")))
        
        newForms.append(self.makeTextLineCell("特设费用".languageString(), value: "¥"+dataDict.stringValue(forKey: "specailAmount")))
        
        //showFeeList
        
        if let showFeeList = dataDict["showFeeList"] as? [[String:Any]] {
            for item in showFeeList {
                newForms.append(self.makeTextLineCell(item.stringValue(forKey: "name"), value: "¥"+item.stringValue(forKey: "value")))
            }
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_SettlementDetailAmount>.init(data: ("结算单调整金额：".languageString(),dataDict.stringValue(forKey: "adjustAmount")), config: uiConfigModel, id: nil, frameh: 50, didSelect:  {  [weak self] in
                //查看详情
                guard let weakSelf = self else { return }
                R_SettlementDetailAdjustList.router(["settleId":weakSelf.dataDict.stringValue(forKey: "settleId")]) { a in
                    
                }
                
            })
            newForms.append(rowCell)
        }
        
     
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
    
    func makePayInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            let rowCell = TCFormCellModel<Cell_FinishHeader>.init(data: ("付款信息".languageString(),""), config: uiConfigModel, id: nil, frameh: 40) { a in
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        newForms.append(self.makeTextLineCell("付款方式".languageString(), value: dataDict.stringValue(forKey: "payTypeName")))
        
        newForms.append(self.makeTextLineCell("转货款金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "zhkAmount")))
        
        newForms.append(self.makeTextLineCell("转配件款金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "zpjAmount")))
        
        newForms.append(self.makeTextLineCell("付现金额".languageString(), value: "¥"+dataDict.stringValue(forKey: "realpayAmount")))
        
        newForms.append(self.makeTextLineCell("银行名称".languageString(), value: dataDict.stringValue(forKey: "bankName")))
        
        newForms.append(self.makeTextLineCell("银行账号".languageString(), value: dataDict.stringValue(forKey: "bankAccount")))
        
        newForms.append(self.makeTextLineCell("银行账户".languageString(), value: dataDict.stringValue(forKey: "bankAccountName")))
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        return newForms
    }
        
    
    func makeTextLineCell(_ title:String,value:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.left)
        let rowCell = TCFormCellModel<TCLabelCell>.init(data: (88, value, ""), config: uiConfigModel, id: nil, frameh: 34, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
}
