//
//  SettlementOrderLineListVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/21.
//

import UIKit

class SettlementOrderLineListVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var dataArray = [[String:Any]]()
    var vcType:OrderLineType = .普通工单
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        
        newForms += makeInfoForms()
     
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        guard self.dataArray.count != 0 else {
            return []
        }
        
        for item in dataArray {
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                var title = ""
                if vcType == .普通工单{
                    title = "单号: ".languageString()+item.stringValue(forKey: "orderNo")
                }else{
                    title = "单号: ".languageString()+item.stringValue(forKey: "checkBillNo")
                }
                let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                    .title(title)
                    .titleFont(UIFont.boldSystemFont(ofSize: 15))
                    .titleColor(UIColor(hexString: "333333"))
                    .infoFont(UIFont.systemFont(ofSize: 14))
                    .infoColor(UIColor(hexString: "333333"))
                    .showNext(false)
                    .showLine(true)
                    .textAlignment(.right)
               
                let rowCell = TCFormCellModel<TCLabelCell>.init(data: (SCREEN_W-30, "", ""), config: uiConfigModel, id: nil, frameh: UITableView.automaticDimension, didSelect:  { [weak self] in
                })
                newForms.append(rowCell)
            }
            
            if vcType == .普通工单{
                
                newForms.append(self.makeTextLineCell("服务类型".languageString(), value: item.stringValue(forKey: "serviceTypeName")))
                newForms.append(self.makeTextLineCell("结算对象".languageString(), value: item.stringValue(forKey: "siteName")))
                newForms.append(self.makeTextLineCell("工单金额".languageString(), value: "¥"+item.stringValue(forKey: "siteFinalAmount")))
            }else{
                newForms.append(self.makeTextLineCell("服务类型".languageString(), value: item.stringValue(forKey: "checkSubjectName")))
                newForms.append(self.makeTextLineCell("考核对象".languageString(), value: item.stringValue(forKey: "siteName")))
                newForms.append(self.makeTextLineCell("工单金额".languageString(), value: "¥"+item.stringValue(forKey: "checkAmount")))
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
            do {
                let uiConfigModel = TCFormCellConfigModel.defaultModel()
                    .bgColor(.clear)
                    .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                    .cornerRadius(8)
                let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
                newForms.append(rowCell)
            }
            
        }
        
       
       return newForms
    }
    
    
    func makeTextLineCell(_ title:String,value:String)->TCCellBaseProtocol {
        let uiConfigModel = TCFormCellConfigModel.defaultModel().setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
            .title(title)
            .titleFont(UIFont.systemFont(ofSize: 14))
            .titleColor(UIColor(hexString: "#999999"))
            .infoFont(UIFont.systemFont(ofSize: 14))
            .infoColor(UIColor(hexString: "333333"))
            .showNext(false)
            .showLine(false)
            .textAlignment(.left)
        let rowCell = TCFormCellModel<TCLabelCell>.init(data: (70, value, ""), config: uiConfigModel, id: nil, frameh: 34, didSelect:  { [weak self] in
        })
        
        return rowCell
    }
    
}
