//
//  SettlementOrderUploadInvoiceVm.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/28.
//

import UIKit

class SettlementOrderUploadInvoiceVm: NSObject {
    var forms:[TCCellBaseProtocol] = []
    var callback:(()->())?
    var imageCallback:((Int)->())?
    
    var invoiceNo = ""
    var invoiceAmount = ""
    
    var pic1 = ""
    var pic2 = ""
    var pic3 = ""
    
    func makeForms(){
       var newForms:[TCCellBaseProtocol] = []
        newForms += makeInfoForms()
        forms = newForms
        callback?()
    }
    
    func makeInfoForms()->[TCCellBaseProtocol]{
        var newForms:[TCCellBaseProtocol] = []
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (0, 0, UIColor(hexString: "f8f8f8")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMinYCorner, .layerMaxXMinYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 5)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "发票号".languageString())
                .canEdit(true)
            let rowCell = TCFormCellModel<Cell_SettlementInvoceCode>.init(data: (invoiceNo, "发票号*".languageString()), config: cfModel, id: nil, frameh: 52, callBack: { [weak self] callValue in
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.invoiceNo = cValue.1
        
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
                if let actionStr = callValue as? String {
                    //扫码
                    let qrVC = QRViewController()
                    qrVC.configResultCall { code, errorStr in
                        if errorStr != "" {
                            CD.visibleVC?.promptInformation(errorStr ?? "扫码出错了~".languageString())
                            return
                        }
                        self?.invoiceNo = code ?? ""
                        self?.makeForms()
                    }
                    let qrNavigationC = TWNavigationVc(rootViewController: qrVC)
                    qrNavigationC.modalPresentationStyle = .overFullScreen
                    qrNavigationC.modalTransitionStyle = .crossDissolve
                    CD.visibleVC?.present(qrNavigationC, animated: true, completion: nil)
                    
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
        
        do {
            let cfModel = TCFormCellConfigModel(titleStr: "发票金额".languageString()).showTip(false).setBgViewLeading(12).setBgViewTrailing(12).setCellColor(UIColor(hexString: "f8f8f8"))
                .bgColor(UIColor(hexString: "ffffff"))
                .infoColor(UIColor(hexString: "#333333"))
                .infoFont(UIFont.systemFont(ofSize: 15))
                .titleColor(UIColor.init(hexString: "666666"))
                .textAlignment(.right)
                .showLine(true)
                .canEdit(true)
            
            let placeholderText = "请输入".languageString()
            let rowCell = TCFormCellModel<TCTextFieldCell>.init(data: (64, invoiceAmount, placeholderText, nil, nil), config: cfModel, id: nil, frameh: UITableView.automaticDimension, callBack: { [weak self] callValue in
                guard let weakSelf = self else { return }
            
                if let cValue = callValue as? (UIControl.Event, String) {
                    if cValue.0 == .editingChanged  {
                        self?.invoiceAmount = cValue.1
                       
                    }else if cValue.0 == .editingDidEnd  {
                        self?.makeForms()
                    }
                }
            }, didSelect: nil)
            newForms.append(rowCell)
        }
      
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
            uiConfigModel.title("发票图片*".languageString())
            let rowCell = TCFormCellModel<Cell_SettlementDetailImage>.init(data: (pic1,pic2,pic3), config: uiConfigModel, id: nil, frameh: 144) {[weak self] (a) in
                guard let weakSelf = self else { return }
        
                if let theTag = a as? Int {
                    self?.imageCallback?(theTag)
                }
                
                if let theTag = a as? String {
                    if theTag == "delete1"{
                        self?.pic1 = ""
                    }
                   else if theTag == "delete2"{
                       self?.pic2 = ""
                    }
                    else if theTag == "delete3"{
                        self?.pic3 = ""
                    }
                    
                    self?.makeForms()
                }
               
            }
            newForms.append(rowCell)
        }
        
        do {
            let uiConfigModel = TCFormCellConfigModel.defaultModel()
                .bgColor(.clear)
                .cornerMask([.layerMinXMaxYCorner, .layerMaxXMaxYCorner])
                .cornerRadius(8)
            let rowCell = TCFormCellModel<TCLineCell>.init(data: (12, 12, UIColor(hexString: "ffffff")), config: uiConfigModel, id: nil, frameh: 10)
            newForms.append(rowCell)
        }

        
       return newForms
    }
}
